// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DdosDetectionMode;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficDetectionRule;
import java.io.IOException;

/**
 * DDoS detection rule properties.
 */
@Fluent
public final class DdosDetectionRulePropertiesFormat implements JsonSerializable<DdosDetectionRulePropertiesFormat> {
    /*
     * The provisioning state of the DDoS detection rule.
     */
    private ProvisioningState provisioningState;

    /*
     * The detection mode for the DDoS detection rule.
     */
    private DdosDetectionMode detectionMode;

    /*
     * The traffic detection rule details.
     */
    private TrafficDetectionRule trafficDetectionRule;

    /**
     * Creates an instance of DdosDetectionRulePropertiesFormat class.
     */
    public DdosDetectionRulePropertiesFormat() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the DDoS detection rule.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the detectionMode property: The detection mode for the DDoS detection rule.
     * 
     * @return the detectionMode value.
     */
    public DdosDetectionMode detectionMode() {
        return this.detectionMode;
    }

    /**
     * Set the detectionMode property: The detection mode for the DDoS detection rule.
     * 
     * @param detectionMode the detectionMode value to set.
     * @return the DdosDetectionRulePropertiesFormat object itself.
     */
    public DdosDetectionRulePropertiesFormat withDetectionMode(DdosDetectionMode detectionMode) {
        this.detectionMode = detectionMode;
        return this;
    }

    /**
     * Get the trafficDetectionRule property: The traffic detection rule details.
     * 
     * @return the trafficDetectionRule value.
     */
    public TrafficDetectionRule trafficDetectionRule() {
        return this.trafficDetectionRule;
    }

    /**
     * Set the trafficDetectionRule property: The traffic detection rule details.
     * 
     * @param trafficDetectionRule the trafficDetectionRule value to set.
     * @return the DdosDetectionRulePropertiesFormat object itself.
     */
    public DdosDetectionRulePropertiesFormat withTrafficDetectionRule(TrafficDetectionRule trafficDetectionRule) {
        this.trafficDetectionRule = trafficDetectionRule;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (trafficDetectionRule() != null) {
            trafficDetectionRule().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("detectionMode", this.detectionMode == null ? null : this.detectionMode.toString());
        jsonWriter.writeJsonField("trafficDetectionRule", this.trafficDetectionRule);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DdosDetectionRulePropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DdosDetectionRulePropertiesFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DdosDetectionRulePropertiesFormat.
     */
    public static DdosDetectionRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DdosDetectionRulePropertiesFormat deserializedDdosDetectionRulePropertiesFormat
                = new DdosDetectionRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedDdosDetectionRulePropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("detectionMode".equals(fieldName)) {
                    deserializedDdosDetectionRulePropertiesFormat.detectionMode
                        = DdosDetectionMode.fromString(reader.getString());
                } else if ("trafficDetectionRule".equals(fieldName)) {
                    deserializedDdosDetectionRulePropertiesFormat.trafficDetectionRule
                        = TrafficDetectionRule.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDdosDetectionRulePropertiesFormat;
        });
    }
}
