// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.InboundNatRulePortMapping;
import java.io.IOException;
import java.util.List;

/**
 * The response for a QueryInboundNatRulePortMapping API.
 */
@Fluent
public final class BackendAddressInboundNatRulePortMappingsInner
    implements JsonSerializable<BackendAddressInboundNatRulePortMappingsInner> {
    /*
     * Collection of inbound NAT rule port mappings.
     */
    private List<InboundNatRulePortMapping> inboundNatRulePortMappings;

    /**
     * Creates an instance of BackendAddressInboundNatRulePortMappingsInner class.
     */
    public BackendAddressInboundNatRulePortMappingsInner() {
    }

    /**
     * Get the inboundNatRulePortMappings property: Collection of inbound NAT rule port mappings.
     * 
     * @return the inboundNatRulePortMappings value.
     */
    public List<InboundNatRulePortMapping> inboundNatRulePortMappings() {
        return this.inboundNatRulePortMappings;
    }

    /**
     * Set the inboundNatRulePortMappings property: Collection of inbound NAT rule port mappings.
     * 
     * @param inboundNatRulePortMappings the inboundNatRulePortMappings value to set.
     * @return the BackendAddressInboundNatRulePortMappingsInner object itself.
     */
    public BackendAddressInboundNatRulePortMappingsInner
        withInboundNatRulePortMappings(List<InboundNatRulePortMapping> inboundNatRulePortMappings) {
        this.inboundNatRulePortMappings = inboundNatRulePortMappings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (inboundNatRulePortMappings() != null) {
            inboundNatRulePortMappings().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inboundNatRulePortMappings", this.inboundNatRulePortMappings,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendAddressInboundNatRulePortMappingsInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendAddressInboundNatRulePortMappingsInner if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendAddressInboundNatRulePortMappingsInner.
     */
    public static BackendAddressInboundNatRulePortMappingsInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendAddressInboundNatRulePortMappingsInner deserializedBackendAddressInboundNatRulePortMappingsInner
                = new BackendAddressInboundNatRulePortMappingsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inboundNatRulePortMappings".equals(fieldName)) {
                    List<InboundNatRulePortMapping> inboundNatRulePortMappings
                        = reader.readArray(reader1 -> InboundNatRulePortMapping.fromJson(reader1));
                    deserializedBackendAddressInboundNatRulePortMappingsInner.inboundNatRulePortMappings
                        = inboundNatRulePortMappings;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendAddressInboundNatRulePortMappingsInner;
        });
    }
}
