// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslCipherSuite;
import com.azure.resourcemanager.network.models.ApplicationGatewaySslProtocol;
import java.io.IOException;
import java.util.List;

/**
 * An Ssl predefined policy.
 */
@Fluent
public final class ApplicationGatewaySslPredefinedPolicyInner extends SubResource {
    /*
     * Name of the Ssl predefined policy.
     */
    private String name;

    /*
     * Properties of the application gateway SSL predefined policy.
     */
    private ApplicationGatewaySslPredefinedPolicyPropertiesFormat innerProperties;

    /**
     * Creates an instance of ApplicationGatewaySslPredefinedPolicyInner class.
     */
    public ApplicationGatewaySslPredefinedPolicyInner() {
    }

    /**
     * Get the name property: Name of the Ssl predefined policy.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Ssl predefined policy.
     * 
     * @param name the name value to set.
     * @return the ApplicationGatewaySslPredefinedPolicyInner object itself.
     */
    public ApplicationGatewaySslPredefinedPolicyInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of the application gateway SSL predefined policy.
     * 
     * @return the innerProperties value.
     */
    private ApplicationGatewaySslPredefinedPolicyPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApplicationGatewaySslPredefinedPolicyInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the cipherSuites property: Ssl cipher suites to be enabled in the specified order for application gateway.
     * 
     * @return the cipherSuites value.
     */
    public List<ApplicationGatewaySslCipherSuite> cipherSuites() {
        return this.innerProperties() == null ? null : this.innerProperties().cipherSuites();
    }

    /**
     * Set the cipherSuites property: Ssl cipher suites to be enabled in the specified order for application gateway.
     * 
     * @param cipherSuites the cipherSuites value to set.
     * @return the ApplicationGatewaySslPredefinedPolicyInner object itself.
     */
    public ApplicationGatewaySslPredefinedPolicyInner
        withCipherSuites(List<ApplicationGatewaySslCipherSuite> cipherSuites) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslPredefinedPolicyPropertiesFormat();
        }
        this.innerProperties().withCipherSuites(cipherSuites);
        return this;
    }

    /**
     * Get the minProtocolVersion property: Minimum version of Ssl protocol to be supported on application gateway.
     * 
     * @return the minProtocolVersion value.
     */
    public ApplicationGatewaySslProtocol minProtocolVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minProtocolVersion();
    }

    /**
     * Set the minProtocolVersion property: Minimum version of Ssl protocol to be supported on application gateway.
     * 
     * @param minProtocolVersion the minProtocolVersion value to set.
     * @return the ApplicationGatewaySslPredefinedPolicyInner object itself.
     */
    public ApplicationGatewaySslPredefinedPolicyInner
        withMinProtocolVersion(ApplicationGatewaySslProtocol minProtocolVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewaySslPredefinedPolicyPropertiesFormat();
        }
        this.innerProperties().withMinProtocolVersion(minProtocolVersion);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewaySslPredefinedPolicyInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewaySslPredefinedPolicyInner if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewaySslPredefinedPolicyInner.
     */
    public static ApplicationGatewaySslPredefinedPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewaySslPredefinedPolicyInner deserializedApplicationGatewaySslPredefinedPolicyInner
                = new ApplicationGatewaySslPredefinedPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewaySslPredefinedPolicyInner.withId(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedApplicationGatewaySslPredefinedPolicyInner.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewaySslPredefinedPolicyInner.innerProperties
                        = ApplicationGatewaySslPredefinedPolicyPropertiesFormat.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewaySslPredefinedPolicyInner;
        });
    }
}
