// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayUnAuthorizedRequestAction;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of entra jwt validation configuration of the application gateway.
 */
@Fluent
public final class ApplicationGatewayEntraJwtValidationConfigPropertiesFormat
    implements JsonSerializable<ApplicationGatewayEntraJwtValidationConfigPropertiesFormat> {
    /*
     * Unauthorized request action.
     */
    private ApplicationGatewayUnAuthorizedRequestAction unAuthorizedRequestAction;

    /*
     * The Tenant ID of the Microsoft Entra ID application.
     */
    private String tenantId;

    /*
     * The Client ID of the Microsoft Entra ID application.
     */
    private String clientId;

    /*
     * List of acceptable audience claims that can be present in the token (aud claim). A maximum of 5 audiences are
     * permitted.
     */
    private List<String> audiences;

    /*
     * The provisioning state of the entra jwt validation configuration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayEntraJwtValidationConfigPropertiesFormat class.
     */
    public ApplicationGatewayEntraJwtValidationConfigPropertiesFormat() {
    }

    /**
     * Get the unAuthorizedRequestAction property: Unauthorized request action.
     * 
     * @return the unAuthorizedRequestAction value.
     */
    public ApplicationGatewayUnAuthorizedRequestAction unAuthorizedRequestAction() {
        return this.unAuthorizedRequestAction;
    }

    /**
     * Set the unAuthorizedRequestAction property: Unauthorized request action.
     * 
     * @param unAuthorizedRequestAction the unAuthorizedRequestAction value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfigPropertiesFormat object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfigPropertiesFormat
        withUnAuthorizedRequestAction(ApplicationGatewayUnAuthorizedRequestAction unAuthorizedRequestAction) {
        this.unAuthorizedRequestAction = unAuthorizedRequestAction;
        return this;
    }

    /**
     * Get the tenantId property: The Tenant ID of the Microsoft Entra ID application.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The Tenant ID of the Microsoft Entra ID application.
     * 
     * @param tenantId the tenantId value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfigPropertiesFormat object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfigPropertiesFormat withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the clientId property: The Client ID of the Microsoft Entra ID application.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The Client ID of the Microsoft Entra ID application.
     * 
     * @param clientId the clientId value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfigPropertiesFormat object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfigPropertiesFormat withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the audiences property: List of acceptable audience claims that can be present in the token (aud claim). A
     * maximum of 5 audiences are permitted.
     * 
     * @return the audiences value.
     */
    public List<String> audiences() {
        return this.audiences;
    }

    /**
     * Set the audiences property: List of acceptable audience claims that can be present in the token (aud claim). A
     * maximum of 5 audiences are permitted.
     * 
     * @param audiences the audiences value to set.
     * @return the ApplicationGatewayEntraJwtValidationConfigPropertiesFormat object itself.
     */
    public ApplicationGatewayEntraJwtValidationConfigPropertiesFormat withAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the entra jwt validation configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unAuthorizedRequestAction",
            this.unAuthorizedRequestAction == null ? null : this.unAuthorizedRequestAction.toString());
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeArrayField("audiences", this.audiences, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayEntraJwtValidationConfigPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayEntraJwtValidationConfigPropertiesFormat if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ApplicationGatewayEntraJwtValidationConfigPropertiesFormat.
     */
    public static ApplicationGatewayEntraJwtValidationConfigPropertiesFormat fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayEntraJwtValidationConfigPropertiesFormat deserializedApplicationGatewayEntraJwtValidationConfigPropertiesFormat
                = new ApplicationGatewayEntraJwtValidationConfigPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("unAuthorizedRequestAction".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfigPropertiesFormat.unAuthorizedRequestAction
                        = ApplicationGatewayUnAuthorizedRequestAction.fromString(reader.getString());
                } else if ("tenantId".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfigPropertiesFormat.tenantId
                        = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfigPropertiesFormat.clientId
                        = reader.getString();
                } else if ("audiences".equals(fieldName)) {
                    List<String> audiences = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationGatewayEntraJwtValidationConfigPropertiesFormat.audiences = audiences;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayEntraJwtValidationConfigPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayEntraJwtValidationConfigPropertiesFormat;
        });
    }
}
