// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

/**
 * Properties of Backend address pool settings of an application gateway.
 */
@Fluent
public final class ApplicationGatewayBackendSettingsPropertiesFormat
    implements JsonSerializable<ApplicationGatewayBackendSettingsPropertiesFormat> {
    /*
     * The destination port on the backend.
     */
    private Integer port;

    /*
     * The protocol used to communicate with the backend.
     */
    private ApplicationGatewayProtocol protocol;

    /*
     * Connection timeout in seconds. Application Gateway will fail the request if response is not received within
     * ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
     */
    private Integer timeout;

    /*
     * Probe resource of an application gateway.
     */
    private SubResource probe;

    /*
     * Array of references to application gateway trusted root certificates.
     */
    private List<SubResource> trustedRootCertificates;

    /*
     * Server name indication to be sent to the backend servers for Tls protocol.
     */
    private String hostname;

    /*
     * Whether to pick server name indication from the host name of the backend server for Tls protocol. Default value
     * is false.
     */
    private Boolean pickHostnameFromBackendAddress;

    /*
     * Whether to send Proxy Protocol header to backend servers over TCP or TLS protocols. Default value is false.
     */
    private Boolean enableL4ClientIpPreservation;

    /*
     * The provisioning state of the backend HTTP settings resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of ApplicationGatewayBackendSettingsPropertiesFormat class.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat() {
    }

    /**
     * Get the port property: The destination port on the backend.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: The destination port on the backend.
     * 
     * @param port the port value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Get the protocol property: The protocol used to communicate with the backend.
     * 
     * @return the protocol value.
     */
    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol used to communicate with the backend.
     * 
     * @param protocol the protocol value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the timeout property: Connection timeout in seconds. Application Gateway will fail the request if response is
     * not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
     * 
     * @return the timeout value.
     */
    public Integer timeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: Connection timeout in seconds. Application Gateway will fail the request if response is
     * not received within ConnectionTimeout. Acceptable values are from 1 second to 86400 seconds.
     * 
     * @param timeout the timeout value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the probe property: Probe resource of an application gateway.
     * 
     * @return the probe value.
     */
    public SubResource probe() {
        return this.probe;
    }

    /**
     * Set the probe property: Probe resource of an application gateway.
     * 
     * @param probe the probe value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat withProbe(SubResource probe) {
        this.probe = probe;
        return this;
    }

    /**
     * Get the trustedRootCertificates property: Array of references to application gateway trusted root certificates.
     * 
     * @return the trustedRootCertificates value.
     */
    public List<SubResource> trustedRootCertificates() {
        return this.trustedRootCertificates;
    }

    /**
     * Set the trustedRootCertificates property: Array of references to application gateway trusted root certificates.
     * 
     * @param trustedRootCertificates the trustedRootCertificates value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat
        withTrustedRootCertificates(List<SubResource> trustedRootCertificates) {
        this.trustedRootCertificates = trustedRootCertificates;
        return this;
    }

    /**
     * Get the hostname property: Server name indication to be sent to the backend servers for Tls protocol.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: Server name indication to be sent to the backend servers for Tls protocol.
     * 
     * @param hostname the hostname value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Get the pickHostnameFromBackendAddress property: Whether to pick server name indication from the host name of the
     * backend server for Tls protocol. Default value is false.
     * 
     * @return the pickHostnameFromBackendAddress value.
     */
    public Boolean pickHostnameFromBackendAddress() {
        return this.pickHostnameFromBackendAddress;
    }

    /**
     * Set the pickHostnameFromBackendAddress property: Whether to pick server name indication from the host name of the
     * backend server for Tls protocol. Default value is false.
     * 
     * @param pickHostnameFromBackendAddress the pickHostnameFromBackendAddress value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat
        withPickHostnameFromBackendAddress(Boolean pickHostnameFromBackendAddress) {
        this.pickHostnameFromBackendAddress = pickHostnameFromBackendAddress;
        return this;
    }

    /**
     * Get the enableL4ClientIpPreservation property: Whether to send Proxy Protocol header to backend servers over TCP
     * or TLS protocols. Default value is false.
     * 
     * @return the enableL4ClientIpPreservation value.
     */
    public Boolean enableL4ClientIpPreservation() {
        return this.enableL4ClientIpPreservation;
    }

    /**
     * Set the enableL4ClientIpPreservation property: Whether to send Proxy Protocol header to backend servers over TCP
     * or TLS protocols. Default value is false.
     * 
     * @param enableL4ClientIpPreservation the enableL4ClientIpPreservation value to set.
     * @return the ApplicationGatewayBackendSettingsPropertiesFormat object itself.
     */
    public ApplicationGatewayBackendSettingsPropertiesFormat
        withEnableL4ClientIpPreservation(Boolean enableL4ClientIpPreservation) {
        this.enableL4ClientIpPreservation = enableL4ClientIpPreservation;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the backend HTTP settings resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("timeout", this.timeout);
        jsonWriter.writeJsonField("probe", this.probe);
        jsonWriter.writeArrayField("trustedRootCertificates", this.trustedRootCertificates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("hostName", this.hostname);
        jsonWriter.writeBooleanField("pickHostNameFromBackendAddress", this.pickHostnameFromBackendAddress);
        jsonWriter.writeBooleanField("enableL4ClientIpPreservation", this.enableL4ClientIpPreservation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayBackendSettingsPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayBackendSettingsPropertiesFormat if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayBackendSettingsPropertiesFormat.
     */
    public static ApplicationGatewayBackendSettingsPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayBackendSettingsPropertiesFormat deserializedApplicationGatewayBackendSettingsPropertiesFormat
                = new ApplicationGatewayBackendSettingsPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("port".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.port
                        = reader.getNullable(JsonReader::getInt);
                } else if ("protocol".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.protocol
                        = ApplicationGatewayProtocol.fromString(reader.getString());
                } else if ("timeout".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.timeout
                        = reader.getNullable(JsonReader::getInt);
                } else if ("probe".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.probe = SubResource.fromJson(reader);
                } else if ("trustedRootCertificates".equals(fieldName)) {
                    List<SubResource> trustedRootCertificates
                        = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.trustedRootCertificates
                        = trustedRootCertificates;
                } else if ("hostName".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.hostname = reader.getString();
                } else if ("pickHostNameFromBackendAddress".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.pickHostnameFromBackendAddress
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("enableL4ClientIpPreservation".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.enableL4ClientIpPreservation
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayBackendSettingsPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayBackendSettingsPropertiesFormat;
        });
    }
}
