// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.ServiceTagsListResultInner;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ServiceTagsClient.
 */
public interface ServiceTagsClient {
    /**
     * Gets a list of service tag information resources.
     * 
     * @param location The location that will be used as a reference for version (not as a filter based on location, you
     * will get the list of service tags with prefix details across all regions but limited to the cloud that your
     * subscription belongs to).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service tag information resources along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ServiceTagsListResultInner>> listWithResponseAsync(String location);

    /**
     * Gets a list of service tag information resources.
     * 
     * @param location The location that will be used as a reference for version (not as a filter based on location, you
     * will get the list of service tags with prefix details across all regions but limited to the cloud that your
     * subscription belongs to).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service tag information resources on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ServiceTagsListResultInner> listAsync(String location);

    /**
     * Gets a list of service tag information resources.
     * 
     * @param location The location that will be used as a reference for version (not as a filter based on location, you
     * will get the list of service tags with prefix details across all regions but limited to the cloud that your
     * subscription belongs to).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service tag information resources along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ServiceTagsListResultInner> listWithResponse(String location, Context context);

    /**
     * Gets a list of service tag information resources.
     * 
     * @param location The location that will be used as a reference for version (not as a filter based on location, you
     * will get the list of service tags with prefix details across all regions but limited to the cloud that your
     * subscription belongs to).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of service tag information resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ServiceTagsListResultInner list(String location);
}
