/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ServiceEndpointPropertiesFormat
implements JsonSerializable<ServiceEndpointPropertiesFormat> {
    private String service;
    private SubResource networkIdentifier;
    private List<String> locations;
    private ProvisioningState provisioningState;

    public String service() {
        return this.service;
    }

    public ServiceEndpointPropertiesFormat withService(String service) {
        this.service = service;
        return this;
    }

    public SubResource networkIdentifier() {
        return this.networkIdentifier;
    }

    public ServiceEndpointPropertiesFormat withNetworkIdentifier(SubResource networkIdentifier) {
        this.networkIdentifier = networkIdentifier;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public ServiceEndpointPropertiesFormat withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("service", this.service);
        jsonWriter.writeJsonField("networkIdentifier", (JsonSerializable)this.networkIdentifier);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ServiceEndpointPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceEndpointPropertiesFormat)jsonReader.readObject(reader -> {
            ServiceEndpointPropertiesFormat deserializedServiceEndpointPropertiesFormat = new ServiceEndpointPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("service".equals(fieldName)) {
                    deserializedServiceEndpointPropertiesFormat.service = reader.getString();
                    continue;
                }
                if ("networkIdentifier".equals(fieldName)) {
                    deserializedServiceEndpointPropertiesFormat.networkIdentifier = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedServiceEndpointPropertiesFormat.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedServiceEndpointPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceEndpointPropertiesFormat;
        });
    }
}

