/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayTrustedClientCertificatePropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ApplicationGatewayTrustedClientCertificate
extends SubResource {
    private ApplicationGatewayTrustedClientCertificatePropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private ApplicationGatewayTrustedClientCertificatePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ApplicationGatewayTrustedClientCertificate withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ApplicationGatewayTrustedClientCertificate withId(String id) {
        super.withId(id);
        return this;
    }

    public String data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    public ApplicationGatewayTrustedClientCertificate withData(String data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayTrustedClientCertificatePropertiesFormat();
        }
        this.innerProperties().withData(data);
        return this;
    }

    public String validatedCertData() {
        return this.innerProperties() == null ? null : this.innerProperties().validatedCertData();
    }

    public String clientCertIssuerDN() {
        return this.innerProperties() == null ? null : this.innerProperties().clientCertIssuerDN();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayTrustedClientCertificate fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayTrustedClientCertificate)((Object)jsonReader.readObject(reader -> {
            ApplicationGatewayTrustedClientCertificate deserializedApplicationGatewayTrustedClientCertificate = new ApplicationGatewayTrustedClientCertificate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificate.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificate.innerProperties = ApplicationGatewayTrustedClientCertificatePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificate.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificate.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayTrustedClientCertificate.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayTrustedClientCertificate;
        }));
    }
}

