/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayPrivateLinkIpConfigurationProperties;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ApplicationGatewayPrivateLinkIpConfiguration
extends SubResource {
    private ApplicationGatewayPrivateLinkIpConfigurationProperties innerProperties;
    private String name;
    private String etag;
    private String type;

    private ApplicationGatewayPrivateLinkIpConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ApplicationGatewayPrivateLinkIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ApplicationGatewayPrivateLinkIpConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public String privateIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAddress();
    }

    public ApplicationGatewayPrivateLinkIpConfiguration withPrivateIpAddress(String privateIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayPrivateLinkIpConfigurationProperties();
        }
        this.innerProperties().withPrivateIpAddress(privateIpAddress);
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().privateIpAllocationMethod();
    }

    public ApplicationGatewayPrivateLinkIpConfiguration withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayPrivateLinkIpConfigurationProperties();
        }
        this.innerProperties().withPrivateIpAllocationMethod(privateIpAllocationMethod);
        return this;
    }

    public SubResource subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public ApplicationGatewayPrivateLinkIpConfiguration withSubnet(SubResource subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayPrivateLinkIpConfigurationProperties();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public Boolean primary() {
        return this.innerProperties() == null ? null : this.innerProperties().primary();
    }

    public ApplicationGatewayPrivateLinkIpConfiguration withPrimary(Boolean primary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayPrivateLinkIpConfigurationProperties();
        }
        this.innerProperties().withPrimary(primary);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayPrivateLinkIpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayPrivateLinkIpConfiguration)((Object)jsonReader.readObject(reader -> {
            ApplicationGatewayPrivateLinkIpConfiguration deserializedApplicationGatewayPrivateLinkIpConfiguration = new ApplicationGatewayPrivateLinkIpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfiguration.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfiguration.innerProperties = ApplicationGatewayPrivateLinkIpConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfiguration.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfiguration.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfiguration.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayPrivateLinkIpConfiguration;
        }));
    }
}

