/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddressPool;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHealthHttpSettings;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayBackendHealthPool
implements JsonSerializable<ApplicationGatewayBackendHealthPool> {
    private ApplicationGatewayBackendAddressPool backendAddressPool;
    private List<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection;

    public ApplicationGatewayBackendAddressPool backendAddressPool() {
        return this.backendAddressPool;
    }

    public ApplicationGatewayBackendHealthPool withBackendAddressPool(ApplicationGatewayBackendAddressPool backendAddressPool) {
        this.backendAddressPool = backendAddressPool;
        return this;
    }

    public List<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection() {
        return this.backendHttpSettingsCollection;
    }

    public ApplicationGatewayBackendHealthPool withBackendHttpSettingsCollection(List<ApplicationGatewayBackendHealthHttpSettings> backendHttpSettingsCollection) {
        this.backendHttpSettingsCollection = backendHttpSettingsCollection;
        return this;
    }

    public void validate() {
        if (this.backendAddressPool() != null) {
            this.backendAddressPool().validate();
        }
        if (this.backendHttpSettingsCollection() != null) {
            this.backendHttpSettingsCollection().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backendAddressPool", (JsonSerializable)this.backendAddressPool);
        jsonWriter.writeArrayField("backendHttpSettingsCollection", this.backendHttpSettingsCollection, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayBackendHealthPool fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayBackendHealthPool)jsonReader.readObject(reader -> {
            ApplicationGatewayBackendHealthPool deserializedApplicationGatewayBackendHealthPool = new ApplicationGatewayBackendHealthPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backendAddressPool".equals(fieldName)) {
                    deserializedApplicationGatewayBackendHealthPool.backendAddressPool = ApplicationGatewayBackendAddressPool.fromJson(reader);
                    continue;
                }
                if ("backendHttpSettingsCollection".equals(fieldName)) {
                    List backendHttpSettingsCollection;
                    deserializedApplicationGatewayBackendHealthPool.backendHttpSettingsCollection = backendHttpSettingsCollection = reader.readArray(reader1 -> ApplicationGatewayBackendHealthHttpSettings.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayBackendHealthPool;
        });
    }
}

