/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class PrivateLinkServiceConnectionProperties
implements JsonSerializable<PrivateLinkServiceConnectionProperties> {
    private ProvisioningState provisioningState;
    private String privateLinkServiceId;
    private List<String> groupIds;
    private String requestMessage;
    private PrivateLinkServiceConnectionState privateLinkServiceConnectionState;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String privateLinkServiceId() {
        return this.privateLinkServiceId;
    }

    public PrivateLinkServiceConnectionProperties withPrivateLinkServiceId(String privateLinkServiceId) {
        this.privateLinkServiceId = privateLinkServiceId;
        return this;
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    public PrivateLinkServiceConnectionProperties withGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
        return this;
    }

    public String requestMessage() {
        return this.requestMessage;
    }

    public PrivateLinkServiceConnectionProperties withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public PrivateLinkServiceConnectionProperties withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public void validate() {
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateLinkServiceId", this.privateLinkServiceId);
        jsonWriter.writeArrayField("groupIds", this.groupIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("requestMessage", this.requestMessage);
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        return jsonWriter.writeEndObject();
    }

    public static PrivateLinkServiceConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateLinkServiceConnectionProperties)jsonReader.readObject(reader -> {
            PrivateLinkServiceConnectionProperties deserializedPrivateLinkServiceConnectionProperties = new PrivateLinkServiceConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkServiceId".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionProperties.privateLinkServiceId = reader.getString();
                    continue;
                }
                if ("groupIds".equals(fieldName)) {
                    List groupIds;
                    deserializedPrivateLinkServiceConnectionProperties.groupIds = groupIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("requestMessage".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionProperties.requestMessage = reader.getString();
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedPrivateLinkServiceConnectionProperties.privateLinkServiceConnectionState = PrivateLinkServiceConnectionState.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateLinkServiceConnectionProperties;
        });
    }
}

