/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspLoggingConfigurationProperties;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.List;

public final class NspLoggingConfigurationInner
extends SecurityPerimeterProxyResource {
    private NspLoggingConfigurationProperties innerProperties;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;

    private NspLoggingConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public List<String> enabledLogCategories() {
        return this.innerProperties() == null ? null : this.innerProperties().enabledLogCategories();
    }

    public NspLoggingConfigurationInner withEnabledLogCategories(List<String> enabledLogCategories) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLoggingConfigurationProperties();
        }
        this.innerProperties().withEnabledLogCategories(enabledLogCategories);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public NspLoggingConfigurationInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspLoggingConfigurationProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NspLoggingConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (NspLoggingConfigurationInner)((Object)jsonReader.readObject(reader -> {
            NspLoggingConfigurationInner deserializedNspLoggingConfigurationInner = new NspLoggingConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNspLoggingConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNspLoggingConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNspLoggingConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNspLoggingConfigurationInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNspLoggingConfigurationInner.innerProperties = NspLoggingConfigurationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspLoggingConfigurationInner;
        }));
    }
}

