/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteLinkPropertiesFormat;
import com.azure.resourcemanager.network.models.ExpressRouteLinkAdminState;
import com.azure.resourcemanager.network.models.ExpressRouteLinkConnectorType;
import com.azure.resourcemanager.network.models.ExpressRouteLinkMacSecConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ExpressRouteLinkInner
extends SubResource {
    private ExpressRouteLinkPropertiesFormat innerProperties;
    private String name;
    private String etag;

    private ExpressRouteLinkPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ExpressRouteLinkInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public ExpressRouteLinkInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String routerName() {
        return this.innerProperties() == null ? null : this.innerProperties().routerName();
    }

    public String interfaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().interfaceName();
    }

    public String patchPanelId() {
        return this.innerProperties() == null ? null : this.innerProperties().patchPanelId();
    }

    public String rackId() {
        return this.innerProperties() == null ? null : this.innerProperties().rackId();
    }

    public String coloLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().coloLocation();
    }

    public ExpressRouteLinkConnectorType connectorType() {
        return this.innerProperties() == null ? null : this.innerProperties().connectorType();
    }

    public ExpressRouteLinkAdminState adminState() {
        return this.innerProperties() == null ? null : this.innerProperties().adminState();
    }

    public ExpressRouteLinkInner withAdminState(ExpressRouteLinkAdminState adminState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteLinkPropertiesFormat();
        }
        this.innerProperties().withAdminState(adminState);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ExpressRouteLinkMacSecConfig macSecConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().macSecConfig();
    }

    public ExpressRouteLinkInner withMacSecConfig(ExpressRouteLinkMacSecConfig macSecConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteLinkPropertiesFormat();
        }
        this.innerProperties().withMacSecConfig(macSecConfig);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteLinkInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteLinkInner)((Object)jsonReader.readObject(reader -> {
            ExpressRouteLinkInner deserializedExpressRouteLinkInner = new ExpressRouteLinkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteLinkInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteLinkInner.innerProperties = ExpressRouteLinkPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteLinkInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteLinkInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteLinkInner;
        }));
    }
}

