// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines contents of a web application rule.
 */
@Fluent
public final class WebApplicationFirewallCustomRule implements JsonSerializable<WebApplicationFirewallCustomRule> {
    /*
     * The name of the resource that is unique within a policy. This name can be used to access the resource.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
     */
    private int priority;

    /*
     * Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    private WebApplicationFirewallState state;

    /*
     * Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
     */
    private ApplicationGatewayFirewallRateLimitDuration rateLimitDuration;

    /*
     * Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be greater than or equal to 1
     */
    private Integer rateLimitThreshold;

    /*
     * The rule type.
     */
    private WebApplicationFirewallRuleType ruleType;

    /*
     * List of match conditions.
     */
    private List<MatchCondition> matchConditions;

    /*
     * List of user session identifier group by clauses.
     */
    private List<GroupByUserSession> groupByUserSession;

    /*
     * Type of Actions.
     */
    private WebApplicationFirewallAction action;

    /**
     * Creates an instance of WebApplicationFirewallCustomRule class.
     */
    public WebApplicationFirewallCustomRule() {
    }

    /**
     * Get the name property: The name of the resource that is unique within a policy. This name can be used to access
     * the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a policy. This name can be used to access
     * the resource.
     * 
     * @param name the name value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the priority property: Priority of the rule. Rules with a lower value will be evaluated before rules with a
     * higher value.
     * 
     * @return the priority value.
     */
    public int priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Priority of the rule. Rules with a lower value will be evaluated before rules with a
     * higher value.
     * 
     * @param priority the priority value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the state property: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
     * specified.
     * 
     * @return the state value.
     */
    public WebApplicationFirewallState state() {
        return this.state;
    }

    /**
     * Set the state property: Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not
     * specified.
     * 
     * @param state the state value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withState(WebApplicationFirewallState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the rateLimitDuration property: Duration over which Rate Limit policy will be applied. Applies only when
     * ruleType is RateLimitRule.
     * 
     * @return the rateLimitDuration value.
     */
    public ApplicationGatewayFirewallRateLimitDuration rateLimitDuration() {
        return this.rateLimitDuration;
    }

    /**
     * Set the rateLimitDuration property: Duration over which Rate Limit policy will be applied. Applies only when
     * ruleType is RateLimitRule.
     * 
     * @param rateLimitDuration the rateLimitDuration value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule
        withRateLimitDuration(ApplicationGatewayFirewallRateLimitDuration rateLimitDuration) {
        this.rateLimitDuration = rateLimitDuration;
        return this;
    }

    /**
     * Get the rateLimitThreshold property: Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be
     * greater than or equal to 1.
     * 
     * @return the rateLimitThreshold value.
     */
    public Integer rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    /**
     * Set the rateLimitThreshold property: Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be
     * greater than or equal to 1.
     * 
     * @param rateLimitThreshold the rateLimitThreshold value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withRateLimitThreshold(Integer rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    /**
     * Get the ruleType property: The rule type.
     * 
     * @return the ruleType value.
     */
    public WebApplicationFirewallRuleType ruleType() {
        return this.ruleType;
    }

    /**
     * Set the ruleType property: The rule type.
     * 
     * @param ruleType the ruleType value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withRuleType(WebApplicationFirewallRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    /**
     * Get the matchConditions property: List of match conditions.
     * 
     * @return the matchConditions value.
     */
    public List<MatchCondition> matchConditions() {
        return this.matchConditions;
    }

    /**
     * Set the matchConditions property: List of match conditions.
     * 
     * @param matchConditions the matchConditions value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withMatchConditions(List<MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    /**
     * Get the groupByUserSession property: List of user session identifier group by clauses.
     * 
     * @return the groupByUserSession value.
     */
    public List<GroupByUserSession> groupByUserSession() {
        return this.groupByUserSession;
    }

    /**
     * Set the groupByUserSession property: List of user session identifier group by clauses.
     * 
     * @param groupByUserSession the groupByUserSession value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withGroupByUserSession(List<GroupByUserSession> groupByUserSession) {
        this.groupByUserSession = groupByUserSession;
        return this;
    }

    /**
     * Get the action property: Type of Actions.
     * 
     * @return the action value.
     */
    public WebApplicationFirewallAction action() {
        return this.action;
    }

    /**
     * Set the action property: Type of Actions.
     * 
     * @param action the action value to set.
     * @return the WebApplicationFirewallCustomRule object itself.
     */
    public WebApplicationFirewallCustomRule withAction(WebApplicationFirewallAction action) {
        this.action = action;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ruleType in model WebApplicationFirewallCustomRule"));
        }
        if (matchConditions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property matchConditions in model WebApplicationFirewallCustomRule"));
        } else {
            matchConditions().forEach(e -> e.validate());
        }
        if (groupByUserSession() != null) {
            groupByUserSession().forEach(e -> e.validate());
        }
        if (action() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property action in model WebApplicationFirewallCustomRule"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebApplicationFirewallCustomRule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeArrayField("matchConditions", this.matchConditions,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("rateLimitDuration",
            this.rateLimitDuration == null ? null : this.rateLimitDuration.toString());
        jsonWriter.writeNumberField("rateLimitThreshold", this.rateLimitThreshold);
        jsonWriter.writeArrayField("groupByUserSession", this.groupByUserSession,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebApplicationFirewallCustomRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebApplicationFirewallCustomRule if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebApplicationFirewallCustomRule.
     */
    public static WebApplicationFirewallCustomRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebApplicationFirewallCustomRule deserializedWebApplicationFirewallCustomRule
                = new WebApplicationFirewallCustomRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("priority".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.priority = reader.getInt();
                } else if ("ruleType".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.ruleType
                        = WebApplicationFirewallRuleType.fromString(reader.getString());
                } else if ("matchConditions".equals(fieldName)) {
                    List<MatchCondition> matchConditions
                        = reader.readArray(reader1 -> MatchCondition.fromJson(reader1));
                    deserializedWebApplicationFirewallCustomRule.matchConditions = matchConditions;
                } else if ("action".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.action
                        = WebApplicationFirewallAction.fromString(reader.getString());
                } else if ("name".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.etag = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.state
                        = WebApplicationFirewallState.fromString(reader.getString());
                } else if ("rateLimitDuration".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.rateLimitDuration
                        = ApplicationGatewayFirewallRateLimitDuration.fromString(reader.getString());
                } else if ("rateLimitThreshold".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.rateLimitThreshold
                        = reader.getNullable(JsonReader::getInt);
                } else if ("groupByUserSession".equals(fieldName)) {
                    List<GroupByUserSession> groupByUserSession
                        = reader.readArray(reader1 -> GroupByUserSession.fromJson(reader1));
                    deserializedWebApplicationFirewallCustomRule.groupByUserSession = groupByUserSession;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebApplicationFirewallCustomRule;
        });
    }
}
