// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Start packet capture parameters.
 */
@Fluent
public final class VpnGatewayPacketCaptureStartParameters
    implements JsonSerializable<VpnGatewayPacketCaptureStartParameters> {
    /*
     * Start Packet capture parameters on vpn gateway.
     */
    private String filterData;

    /**
     * Creates an instance of VpnGatewayPacketCaptureStartParameters class.
     */
    public VpnGatewayPacketCaptureStartParameters() {
    }

    /**
     * Get the filterData property: Start Packet capture parameters on vpn gateway.
     * 
     * @return the filterData value.
     */
    public String filterData() {
        return this.filterData;
    }

    /**
     * Set the filterData property: Start Packet capture parameters on vpn gateway.
     * 
     * @param filterData the filterData value to set.
     * @return the VpnGatewayPacketCaptureStartParameters object itself.
     */
    public VpnGatewayPacketCaptureStartParameters withFilterData(String filterData) {
        this.filterData = filterData;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filterData", this.filterData);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnGatewayPacketCaptureStartParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnGatewayPacketCaptureStartParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnGatewayPacketCaptureStartParameters.
     */
    public static VpnGatewayPacketCaptureStartParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnGatewayPacketCaptureStartParameters deserializedVpnGatewayPacketCaptureStartParameters
                = new VpnGatewayPacketCaptureStartParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("filterData".equals(fieldName)) {
                    deserializedVpnGatewayPacketCaptureStartParameters.filterData = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnGatewayPacketCaptureStartParameters;
        });
    }
}
