// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Virtual Wan Vpn profile parameters Vpn profile generation.
 */
@Fluent
public final class VirtualWanVpnProfileParameters implements JsonSerializable<VirtualWanVpnProfileParameters> {
    /*
     * VpnServerConfiguration partial resource uri with which VirtualWan is associated to.
     */
    private String vpnServerConfigurationResourceId;

    /*
     * VPN client authentication method.
     */
    private AuthenticationMethod authenticationMethod;

    /**
     * Creates an instance of VirtualWanVpnProfileParameters class.
     */
    public VirtualWanVpnProfileParameters() {
    }

    /**
     * Get the vpnServerConfigurationResourceId property: VpnServerConfiguration partial resource uri with which
     * VirtualWan is associated to.
     * 
     * @return the vpnServerConfigurationResourceId value.
     */
    public String vpnServerConfigurationResourceId() {
        return this.vpnServerConfigurationResourceId;
    }

    /**
     * Set the vpnServerConfigurationResourceId property: VpnServerConfiguration partial resource uri with which
     * VirtualWan is associated to.
     * 
     * @param vpnServerConfigurationResourceId the vpnServerConfigurationResourceId value to set.
     * @return the VirtualWanVpnProfileParameters object itself.
     */
    public VirtualWanVpnProfileParameters
        withVpnServerConfigurationResourceId(String vpnServerConfigurationResourceId) {
        this.vpnServerConfigurationResourceId = vpnServerConfigurationResourceId;
        return this;
    }

    /**
     * Get the authenticationMethod property: VPN client authentication method.
     * 
     * @return the authenticationMethod value.
     */
    public AuthenticationMethod authenticationMethod() {
        return this.authenticationMethod;
    }

    /**
     * Set the authenticationMethod property: VPN client authentication method.
     * 
     * @param authenticationMethod the authenticationMethod value to set.
     * @return the VirtualWanVpnProfileParameters object itself.
     */
    public VirtualWanVpnProfileParameters withAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vpnServerConfigurationResourceId", this.vpnServerConfigurationResourceId);
        jsonWriter.writeStringField("authenticationMethod",
            this.authenticationMethod == null ? null : this.authenticationMethod.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualWanVpnProfileParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualWanVpnProfileParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualWanVpnProfileParameters.
     */
    public static VirtualWanVpnProfileParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualWanVpnProfileParameters deserializedVirtualWanVpnProfileParameters
                = new VirtualWanVpnProfileParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnServerConfigurationResourceId".equals(fieldName)) {
                    deserializedVirtualWanVpnProfileParameters.vpnServerConfigurationResourceId = reader.getString();
                } else if ("authenticationMethod".equals(fieldName)) {
                    deserializedVirtualWanVpnProfileParameters.authenticationMethod
                        = AuthenticationMethod.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualWanVpnProfileParameters;
        });
    }
}
