// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Usage strings container.
 */
@Immutable
public final class VirtualNetworkUsageName implements JsonSerializable<VirtualNetworkUsageName> {
    /*
     * Localized subnet size and usage string.
     */
    private String localizedValue;

    /*
     * Subnet size and usage string.
     */
    private String value;

    /**
     * Creates an instance of VirtualNetworkUsageName class.
     */
    public VirtualNetworkUsageName() {
    }

    /**
     * Get the localizedValue property: Localized subnet size and usage string.
     * 
     * @return the localizedValue value.
     */
    public String localizedValue() {
        return this.localizedValue;
    }

    /**
     * Get the value property: Subnet size and usage string.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkUsageName from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkUsageName if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkUsageName.
     */
    public static VirtualNetworkUsageName fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkUsageName deserializedVirtualNetworkUsageName = new VirtualNetworkUsageName();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("localizedValue".equals(fieldName)) {
                    deserializedVirtualNetworkUsageName.localizedValue = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedVirtualNetworkUsageName.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkUsageName;
        });
    }
}
