// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of Verifier Workspace resource.
 */
@Fluent
public final class VerifierWorkspaceProperties implements JsonSerializable<VerifierWorkspaceProperties> {
    /*
     * The description property.
     */
    private String description;

    /*
     * Provisioning states of a resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of VerifierWorkspaceProperties class.
     */
    public VerifierWorkspaceProperties() {
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the VerifierWorkspaceProperties object itself.
     */
    public VerifierWorkspaceProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning states of a resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning states of a resource.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the VerifierWorkspaceProperties object itself.
     */
    public VerifierWorkspaceProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VerifierWorkspaceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VerifierWorkspaceProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VerifierWorkspaceProperties.
     */
    public static VerifierWorkspaceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VerifierWorkspaceProperties deserializedVerifierWorkspaceProperties = new VerifierWorkspaceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedVerifierWorkspaceProperties.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVerifierWorkspaceProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVerifierWorkspaceProperties;
        });
    }
}
