// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The SubscriptionId model.
 */
@Fluent
public final class SubscriptionId implements JsonSerializable<SubscriptionId> {
    /*
     * Subscription id in the ARM id format.
     */
    private String id;

    /**
     * Creates an instance of SubscriptionId class.
     */
    public SubscriptionId() {
    }

    /**
     * Get the id property: Subscription id in the ARM id format.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Subscription id in the ARM id format.
     * 
     * @param id the id value to set.
     * @return the SubscriptionId object itself.
     */
    public SubscriptionId withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionId from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionId if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionId.
     */
    public static SubscriptionId fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionId deserializedSubscriptionId = new SubscriptionId();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSubscriptionId.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSubscriptionId;
        });
    }
}
