// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ScopeConnectionInner;
import java.io.IOException;
import java.util.List;

/**
 * List of scope connections.
 */
@Fluent
public final class ScopeConnectionListResult implements JsonSerializable<ScopeConnectionListResult> {
    /*
     * List of scope connections.
     */
    private List<ScopeConnectionInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ScopeConnectionListResult class.
     */
    public ScopeConnectionListResult() {
    }

    /**
     * Get the value property: List of scope connections.
     * 
     * @return the value value.
     */
    public List<ScopeConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of scope connections.
     * 
     * @param value the value value to set.
     * @return the ScopeConnectionListResult object itself.
     */
    public ScopeConnectionListResult withValue(List<ScopeConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ScopeConnectionListResult object itself.
     */
    public ScopeConnectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScopeConnectionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScopeConnectionListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScopeConnectionListResult.
     */
    public static ScopeConnectionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopeConnectionListResult deserializedScopeConnectionListResult = new ScopeConnectionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ScopeConnectionInner> value
                        = reader.readArray(reader1 -> ScopeConnectionInner.fromJson(reader1));
                    deserializedScopeConnectionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedScopeConnectionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScopeConnectionListResult;
        });
    }
}
