// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The RouteSourceDetails model.
 */
@Fluent
public final class RouteSourceDetails implements JsonSerializable<RouteSourceDetails> {
    /*
     * Express Route Circuit identifier
     */
    private String circuit;

    /*
     * Flag to indicate if the route learned from the primary device is active or passive
     */
    private String pri;

    /*
     * Flag to indicate if the route learned from the secondary device is active or passive
     */
    private String sec;

    /**
     * Creates an instance of RouteSourceDetails class.
     */
    public RouteSourceDetails() {
    }

    /**
     * Get the circuit property: Express Route Circuit identifier.
     * 
     * @return the circuit value.
     */
    public String circuit() {
        return this.circuit;
    }

    /**
     * Set the circuit property: Express Route Circuit identifier.
     * 
     * @param circuit the circuit value to set.
     * @return the RouteSourceDetails object itself.
     */
    public RouteSourceDetails withCircuit(String circuit) {
        this.circuit = circuit;
        return this;
    }

    /**
     * Get the pri property: Flag to indicate if the route learned from the primary device is active or passive.
     * 
     * @return the pri value.
     */
    public String pri() {
        return this.pri;
    }

    /**
     * Set the pri property: Flag to indicate if the route learned from the primary device is active or passive.
     * 
     * @param pri the pri value to set.
     * @return the RouteSourceDetails object itself.
     */
    public RouteSourceDetails withPri(String pri) {
        this.pri = pri;
        return this;
    }

    /**
     * Get the sec property: Flag to indicate if the route learned from the secondary device is active or passive.
     * 
     * @return the sec value.
     */
    public String sec() {
        return this.sec;
    }

    /**
     * Set the sec property: Flag to indicate if the route learned from the secondary device is active or passive.
     * 
     * @param sec the sec value to set.
     * @return the RouteSourceDetails object itself.
     */
    public RouteSourceDetails withSec(String sec) {
        this.sec = sec;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("circuit", this.circuit);
        jsonWriter.writeStringField("pri", this.pri);
        jsonWriter.writeStringField("sec", this.sec);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteSourceDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteSourceDetails if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RouteSourceDetails.
     */
    public static RouteSourceDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteSourceDetails deserializedRouteSourceDetails = new RouteSourceDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("circuit".equals(fieldName)) {
                    deserializedRouteSourceDetails.circuit = reader.getString();
                } else if ("pri".equals(fieldName)) {
                    deserializedRouteSourceDetails.pri = reader.getString();
                } else if ("sec".equals(fieldName)) {
                    deserializedRouteSourceDetails.sec = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteSourceDetails;
        });
    }
}
