// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Details of PrepareNetworkPolicies for Subnet.
 */
@Fluent
public final class PrepareNetworkPoliciesRequest implements JsonSerializable<PrepareNetworkPoliciesRequest> {
    /*
     * The name of the service for which subnet is being prepared for.
     */
    private String serviceName;

    /*
     * A list of NetworkIntentPolicyConfiguration.
     */
    private List<NetworkIntentPolicyConfiguration> networkIntentPolicyConfigurations;

    /**
     * Creates an instance of PrepareNetworkPoliciesRequest class.
     */
    public PrepareNetworkPoliciesRequest() {
    }

    /**
     * Get the serviceName property: The name of the service for which subnet is being prepared for.
     * 
     * @return the serviceName value.
     */
    public String serviceName() {
        return this.serviceName;
    }

    /**
     * Set the serviceName property: The name of the service for which subnet is being prepared for.
     * 
     * @param serviceName the serviceName value to set.
     * @return the PrepareNetworkPoliciesRequest object itself.
     */
    public PrepareNetworkPoliciesRequest withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    /**
     * Get the networkIntentPolicyConfigurations property: A list of NetworkIntentPolicyConfiguration.
     * 
     * @return the networkIntentPolicyConfigurations value.
     */
    public List<NetworkIntentPolicyConfiguration> networkIntentPolicyConfigurations() {
        return this.networkIntentPolicyConfigurations;
    }

    /**
     * Set the networkIntentPolicyConfigurations property: A list of NetworkIntentPolicyConfiguration.
     * 
     * @param networkIntentPolicyConfigurations the networkIntentPolicyConfigurations value to set.
     * @return the PrepareNetworkPoliciesRequest object itself.
     */
    public PrepareNetworkPoliciesRequest withNetworkIntentPolicyConfigurations(
        List<NetworkIntentPolicyConfiguration> networkIntentPolicyConfigurations) {
        this.networkIntentPolicyConfigurations = networkIntentPolicyConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (networkIntentPolicyConfigurations() != null) {
            networkIntentPolicyConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceName", this.serviceName);
        jsonWriter.writeArrayField("networkIntentPolicyConfigurations", this.networkIntentPolicyConfigurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrepareNetworkPoliciesRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrepareNetworkPoliciesRequest if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrepareNetworkPoliciesRequest.
     */
    public static PrepareNetworkPoliciesRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrepareNetworkPoliciesRequest deserializedPrepareNetworkPoliciesRequest
                = new PrepareNetworkPoliciesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("serviceName".equals(fieldName)) {
                    deserializedPrepareNetworkPoliciesRequest.serviceName = reader.getString();
                } else if ("networkIntentPolicyConfigurations".equals(fieldName)) {
                    List<NetworkIntentPolicyConfiguration> networkIntentPolicyConfigurations
                        = reader.readArray(reader1 -> NetworkIntentPolicyConfiguration.fromJson(reader1));
                    deserializedPrepareNetworkPoliciesRequest.networkIntentPolicyConfigurations
                        = networkIntentPolicyConfigurations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrepareNetworkPoliciesRequest;
        });
    }
}
