// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The storage location for a packet capture session.
 */
@Fluent
public final class PacketCaptureStorageLocation implements JsonSerializable<PacketCaptureStorageLocation> {
    /*
     * The ID of the storage account to save the packet capture session. Required if no localPath or filePath is
     * provided.
     */
    private String storageId;

    /*
     * The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save
     * the packet capture.
     */
    private String storagePath;

    /*
     * This path is invalid if 'Continuous Capture' is provided with 'true' or 'false'. A valid local path on the
     * targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with
     * /var/captures. Required if no storage ID is provided, otherwise optional.
     */
    private String filePath;

    /*
     * This path is valid if 'Continuous Capture' is provided with 'true' or 'false' and required if no storage ID is
     * provided, otherwise optional. Must include the name of the capture file (*.cap). For linux virtual machine it
     * must start with /var/captures.
     */
    private String localPath;

    /**
     * Creates an instance of PacketCaptureStorageLocation class.
     */
    public PacketCaptureStorageLocation() {
    }

    /**
     * Get the storageId property: The ID of the storage account to save the packet capture session. Required if no
     * localPath or filePath is provided.
     * 
     * @return the storageId value.
     */
    public String storageId() {
        return this.storageId;
    }

    /**
     * Set the storageId property: The ID of the storage account to save the packet capture session. Required if no
     * localPath or filePath is provided.
     * 
     * @param storageId the storageId value to set.
     * @return the PacketCaptureStorageLocation object itself.
     */
    public PacketCaptureStorageLocation withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    /**
     * Get the storagePath property: The URI of the storage path to save the packet capture. Must be a well-formed URI
     * describing the location to save the packet capture.
     * 
     * @return the storagePath value.
     */
    public String storagePath() {
        return this.storagePath;
    }

    /**
     * Set the storagePath property: The URI of the storage path to save the packet capture. Must be a well-formed URI
     * describing the location to save the packet capture.
     * 
     * @param storagePath the storagePath value to set.
     * @return the PacketCaptureStorageLocation object itself.
     */
    public PacketCaptureStorageLocation withStoragePath(String storagePath) {
        this.storagePath = storagePath;
        return this;
    }

    /**
     * Get the filePath property: This path is invalid if 'Continuous Capture' is provided with 'true' or 'false'. A
     * valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual
     * machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
     * 
     * @return the filePath value.
     */
    public String filePath() {
        return this.filePath;
    }

    /**
     * Set the filePath property: This path is invalid if 'Continuous Capture' is provided with 'true' or 'false'. A
     * valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual
     * machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
     * 
     * @param filePath the filePath value to set.
     * @return the PacketCaptureStorageLocation object itself.
     */
    public PacketCaptureStorageLocation withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    /**
     * Get the localPath property: This path is valid if 'Continuous Capture' is provided with 'true' or 'false' and
     * required if no storage ID is provided, otherwise optional. Must include the name of the capture file (*.cap). For
     * linux virtual machine it must start with /var/captures.
     * 
     * @return the localPath value.
     */
    public String localPath() {
        return this.localPath;
    }

    /**
     * Set the localPath property: This path is valid if 'Continuous Capture' is provided with 'true' or 'false' and
     * required if no storage ID is provided, otherwise optional. Must include the name of the capture file (*.cap). For
     * linux virtual machine it must start with /var/captures.
     * 
     * @param localPath the localPath value to set.
     * @return the PacketCaptureStorageLocation object itself.
     */
    public PacketCaptureStorageLocation withLocalPath(String localPath) {
        this.localPath = localPath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageId", this.storageId);
        jsonWriter.writeStringField("storagePath", this.storagePath);
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeStringField("localPath", this.localPath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PacketCaptureStorageLocation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PacketCaptureStorageLocation if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PacketCaptureStorageLocation.
     */
    public static PacketCaptureStorageLocation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PacketCaptureStorageLocation deserializedPacketCaptureStorageLocation = new PacketCaptureStorageLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageId".equals(fieldName)) {
                    deserializedPacketCaptureStorageLocation.storageId = reader.getString();
                } else if ("storagePath".equals(fieldName)) {
                    deserializedPacketCaptureStorageLocation.storagePath = reader.getString();
                } else if ("filePath".equals(fieldName)) {
                    deserializedPacketCaptureStorageLocation.filePath = reader.getString();
                } else if ("localPath".equals(fieldName)) {
                    deserializedPacketCaptureStorageLocation.localPath = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPacketCaptureStorageLocation;
        });
    }
}
