// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 */
@Fluent
public final class OwaspCrsExclusionEntry implements JsonSerializable<OwaspCrsExclusionEntry> {
    /*
     * The variable to be excluded.
     */
    private OwaspCrsExclusionEntryMatchVariable matchVariable;

    /*
     * When matchVariable is a collection, operate on the selector to specify which elements in the collection this
     * exclusion applies to.
     */
    private OwaspCrsExclusionEntrySelectorMatchOperator selectorMatchOperator;

    /*
     * When matchVariable is a collection, operator used to specify which elements in the collection this exclusion
     * applies to.
     */
    private String selector;

    /*
     * The managed rule sets that are associated with the exclusion.
     */
    private List<ExclusionManagedRuleSet> exclusionManagedRuleSets;

    /**
     * Creates an instance of OwaspCrsExclusionEntry class.
     */
    public OwaspCrsExclusionEntry() {
    }

    /**
     * Get the matchVariable property: The variable to be excluded.
     * 
     * @return the matchVariable value.
     */
    public OwaspCrsExclusionEntryMatchVariable matchVariable() {
        return this.matchVariable;
    }

    /**
     * Set the matchVariable property: The variable to be excluded.
     * 
     * @param matchVariable the matchVariable value to set.
     * @return the OwaspCrsExclusionEntry object itself.
     */
    public OwaspCrsExclusionEntry withMatchVariable(OwaspCrsExclusionEntryMatchVariable matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    /**
     * Get the selectorMatchOperator property: When matchVariable is a collection, operate on the selector to specify
     * which elements in the collection this exclusion applies to.
     * 
     * @return the selectorMatchOperator value.
     */
    public OwaspCrsExclusionEntrySelectorMatchOperator selectorMatchOperator() {
        return this.selectorMatchOperator;
    }

    /**
     * Set the selectorMatchOperator property: When matchVariable is a collection, operate on the selector to specify
     * which elements in the collection this exclusion applies to.
     * 
     * @param selectorMatchOperator the selectorMatchOperator value to set.
     * @return the OwaspCrsExclusionEntry object itself.
     */
    public OwaspCrsExclusionEntry
        withSelectorMatchOperator(OwaspCrsExclusionEntrySelectorMatchOperator selectorMatchOperator) {
        this.selectorMatchOperator = selectorMatchOperator;
        return this;
    }

    /**
     * Get the selector property: When matchVariable is a collection, operator used to specify which elements in the
     * collection this exclusion applies to.
     * 
     * @return the selector value.
     */
    public String selector() {
        return this.selector;
    }

    /**
     * Set the selector property: When matchVariable is a collection, operator used to specify which elements in the
     * collection this exclusion applies to.
     * 
     * @param selector the selector value to set.
     * @return the OwaspCrsExclusionEntry object itself.
     */
    public OwaspCrsExclusionEntry withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    /**
     * Get the exclusionManagedRuleSets property: The managed rule sets that are associated with the exclusion.
     * 
     * @return the exclusionManagedRuleSets value.
     */
    public List<ExclusionManagedRuleSet> exclusionManagedRuleSets() {
        return this.exclusionManagedRuleSets;
    }

    /**
     * Set the exclusionManagedRuleSets property: The managed rule sets that are associated with the exclusion.
     * 
     * @param exclusionManagedRuleSets the exclusionManagedRuleSets value to set.
     * @return the OwaspCrsExclusionEntry object itself.
     */
    public OwaspCrsExclusionEntry withExclusionManagedRuleSets(List<ExclusionManagedRuleSet> exclusionManagedRuleSets) {
        this.exclusionManagedRuleSets = exclusionManagedRuleSets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchVariable() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property matchVariable in model OwaspCrsExclusionEntry"));
        }
        if (selectorMatchOperator() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property selectorMatchOperator in model OwaspCrsExclusionEntry"));
        }
        if (selector() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property selector in model OwaspCrsExclusionEntry"));
        }
        if (exclusionManagedRuleSets() != null) {
            exclusionManagedRuleSets().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(OwaspCrsExclusionEntry.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("matchVariable", this.matchVariable == null ? null : this.matchVariable.toString());
        jsonWriter.writeStringField("selectorMatchOperator",
            this.selectorMatchOperator == null ? null : this.selectorMatchOperator.toString());
        jsonWriter.writeStringField("selector", this.selector);
        jsonWriter.writeArrayField("exclusionManagedRuleSets", this.exclusionManagedRuleSets,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OwaspCrsExclusionEntry from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OwaspCrsExclusionEntry if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the OwaspCrsExclusionEntry.
     */
    public static OwaspCrsExclusionEntry fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OwaspCrsExclusionEntry deserializedOwaspCrsExclusionEntry = new OwaspCrsExclusionEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("matchVariable".equals(fieldName)) {
                    deserializedOwaspCrsExclusionEntry.matchVariable
                        = OwaspCrsExclusionEntryMatchVariable.fromString(reader.getString());
                } else if ("selectorMatchOperator".equals(fieldName)) {
                    deserializedOwaspCrsExclusionEntry.selectorMatchOperator
                        = OwaspCrsExclusionEntrySelectorMatchOperator.fromString(reader.getString());
                } else if ("selector".equals(fieldName)) {
                    deserializedOwaspCrsExclusionEntry.selector = reader.getString();
                } else if ("exclusionManagedRuleSets".equals(fieldName)) {
                    List<ExclusionManagedRuleSet> exclusionManagedRuleSets
                        = reader.readArray(reader1 -> ExclusionManagedRuleSet.fromJson(reader1));
                    deserializedOwaspCrsExclusionEntry.exclusionManagedRuleSets = exclusionManagedRuleSets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOwaspCrsExclusionEntry;
        });
    }
}
