// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Subnet references where the NVA NICS will be deployed
 * 
 * The resource URI of the subnets where the NVA NICS will be deployed.
 */
@Fluent
public final class NvaInVnetSubnetReferenceProperties implements JsonSerializable<NvaInVnetSubnetReferenceProperties> {
    /*
     * Resource Uri of Subnet
     */
    private String id;

    /**
     * Creates an instance of NvaInVnetSubnetReferenceProperties class.
     */
    public NvaInVnetSubnetReferenceProperties() {
    }

    /**
     * Get the id property: Resource Uri of Subnet.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource Uri of Subnet.
     * 
     * @param id the id value to set.
     * @return the NvaInVnetSubnetReferenceProperties object itself.
     */
    public NvaInVnetSubnetReferenceProperties withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NvaInVnetSubnetReferenceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NvaInVnetSubnetReferenceProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NvaInVnetSubnetReferenceProperties.
     */
    public static NvaInVnetSubnetReferenceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NvaInVnetSubnetReferenceProperties deserializedNvaInVnetSubnetReferenceProperties
                = new NvaInVnetSubnetReferenceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNvaInVnetSubnetReferenceProperties.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNvaInVnetSubnetReferenceProperties;
        });
    }
}
