// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkWatcherInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListNetworkWatchers API service call.
 */
@Fluent
public final class NetworkWatcherListResult implements JsonSerializable<NetworkWatcherListResult> {
    /*
     * List of network watcher resources.
     */
    private List<NetworkWatcherInner> value;

    /**
     * Creates an instance of NetworkWatcherListResult class.
     */
    public NetworkWatcherListResult() {
    }

    /**
     * Get the value property: List of network watcher resources.
     * 
     * @return the value value.
     */
    public List<NetworkWatcherInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of network watcher resources.
     * 
     * @param value the value value to set.
     * @return the NetworkWatcherListResult object itself.
     */
    public NetworkWatcherListResult withValue(List<NetworkWatcherInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkWatcherListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkWatcherListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkWatcherListResult.
     */
    public static NetworkWatcherListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkWatcherListResult deserializedNetworkWatcherListResult = new NetworkWatcherListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NetworkWatcherInner> value
                        = reader.readArray(reader1 -> NetworkWatcherInner.fromJson(reader1));
                    deserializedNetworkWatcherListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkWatcherListResult;
        });
    }
}
