// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies input parameters required to retrieve the boot diagnostic logs for an NVA instance.
 */
@Fluent
public final class NetworkVirtualApplianceBootDiagnosticParameters
    implements JsonSerializable<NetworkVirtualApplianceBootDiagnosticParameters> {
    /*
     * The network virtual appliance instance id for which boot diagnostic logs is being requested
     */
    private Integer instanceId;

    /*
     * Specifies the sas-url to the storage blob into which serial console logs for the requested instance will be
     * written
     */
    private String serialConsoleStorageSasUrl;

    /*
     * Specifies the sas-url to the storage blob into which console screen shot for the requested instance will be
     * written
     */
    private String consoleScreenshotStorageSasUrl;

    /**
     * Creates an instance of NetworkVirtualApplianceBootDiagnosticParameters class.
     */
    public NetworkVirtualApplianceBootDiagnosticParameters() {
    }

    /**
     * Get the instanceId property: The network virtual appliance instance id for which boot diagnostic logs is being
     * requested.
     * 
     * @return the instanceId value.
     */
    public Integer instanceId() {
        return this.instanceId;
    }

    /**
     * Set the instanceId property: The network virtual appliance instance id for which boot diagnostic logs is being
     * requested.
     * 
     * @param instanceId the instanceId value to set.
     * @return the NetworkVirtualApplianceBootDiagnosticParameters object itself.
     */
    public NetworkVirtualApplianceBootDiagnosticParameters withInstanceId(Integer instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    /**
     * Get the serialConsoleStorageSasUrl property: Specifies the sas-url to the storage blob into which serial console
     * logs for the requested instance will be written.
     * 
     * @return the serialConsoleStorageSasUrl value.
     */
    public String serialConsoleStorageSasUrl() {
        return this.serialConsoleStorageSasUrl;
    }

    /**
     * Set the serialConsoleStorageSasUrl property: Specifies the sas-url to the storage blob into which serial console
     * logs for the requested instance will be written.
     * 
     * @param serialConsoleStorageSasUrl the serialConsoleStorageSasUrl value to set.
     * @return the NetworkVirtualApplianceBootDiagnosticParameters object itself.
     */
    public NetworkVirtualApplianceBootDiagnosticParameters
        withSerialConsoleStorageSasUrl(String serialConsoleStorageSasUrl) {
        this.serialConsoleStorageSasUrl = serialConsoleStorageSasUrl;
        return this;
    }

    /**
     * Get the consoleScreenshotStorageSasUrl property: Specifies the sas-url to the storage blob into which console
     * screen shot for the requested instance will be written.
     * 
     * @return the consoleScreenshotStorageSasUrl value.
     */
    public String consoleScreenshotStorageSasUrl() {
        return this.consoleScreenshotStorageSasUrl;
    }

    /**
     * Set the consoleScreenshotStorageSasUrl property: Specifies the sas-url to the storage blob into which console
     * screen shot for the requested instance will be written.
     * 
     * @param consoleScreenshotStorageSasUrl the consoleScreenshotStorageSasUrl value to set.
     * @return the NetworkVirtualApplianceBootDiagnosticParameters object itself.
     */
    public NetworkVirtualApplianceBootDiagnosticParameters
        withConsoleScreenshotStorageSasUrl(String consoleScreenshotStorageSasUrl) {
        this.consoleScreenshotStorageSasUrl = consoleScreenshotStorageSasUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("instanceId", this.instanceId);
        jsonWriter.writeStringField("serialConsoleStorageSasUrl", this.serialConsoleStorageSasUrl);
        jsonWriter.writeStringField("consoleScreenshotStorageSasUrl", this.consoleScreenshotStorageSasUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkVirtualApplianceBootDiagnosticParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkVirtualApplianceBootDiagnosticParameters if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkVirtualApplianceBootDiagnosticParameters.
     */
    public static NetworkVirtualApplianceBootDiagnosticParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkVirtualApplianceBootDiagnosticParameters deserializedNetworkVirtualApplianceBootDiagnosticParameters
                = new NetworkVirtualApplianceBootDiagnosticParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("instanceId".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceBootDiagnosticParameters.instanceId
                        = reader.getNullable(JsonReader::getInt);
                } else if ("serialConsoleStorageSasUrl".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceBootDiagnosticParameters.serialConsoleStorageSasUrl
                        = reader.getString();
                } else if ("consoleScreenshotStorageSasUrl".equals(fieldName)) {
                    deserializedNetworkVirtualApplianceBootDiagnosticParameters.consoleScreenshotStorageSasUrl
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkVirtualApplianceBootDiagnosticParameters;
        });
    }
}
