// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network configuration diagnostic result corresponded to provided traffic query.
 */
@Fluent
public final class NetworkConfigurationDiagnosticResult
    implements JsonSerializable<NetworkConfigurationDiagnosticResult> {
    /*
     * Network configuration diagnostic profile.
     */
    private NetworkConfigurationDiagnosticProfile profile;

    /*
     * Network security group result.
     */
    private NetworkSecurityGroupResult networkSecurityGroupResult;

    /**
     * Creates an instance of NetworkConfigurationDiagnosticResult class.
     */
    public NetworkConfigurationDiagnosticResult() {
    }

    /**
     * Get the profile property: Network configuration diagnostic profile.
     * 
     * @return the profile value.
     */
    public NetworkConfigurationDiagnosticProfile profile() {
        return this.profile;
    }

    /**
     * Set the profile property: Network configuration diagnostic profile.
     * 
     * @param profile the profile value to set.
     * @return the NetworkConfigurationDiagnosticResult object itself.
     */
    public NetworkConfigurationDiagnosticResult withProfile(NetworkConfigurationDiagnosticProfile profile) {
        this.profile = profile;
        return this;
    }

    /**
     * Get the networkSecurityGroupResult property: Network security group result.
     * 
     * @return the networkSecurityGroupResult value.
     */
    public NetworkSecurityGroupResult networkSecurityGroupResult() {
        return this.networkSecurityGroupResult;
    }

    /**
     * Set the networkSecurityGroupResult property: Network security group result.
     * 
     * @param networkSecurityGroupResult the networkSecurityGroupResult value to set.
     * @return the NetworkConfigurationDiagnosticResult object itself.
     */
    public NetworkConfigurationDiagnosticResult
        withNetworkSecurityGroupResult(NetworkSecurityGroupResult networkSecurityGroupResult) {
        this.networkSecurityGroupResult = networkSecurityGroupResult;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (profile() != null) {
            profile().validate();
        }
        if (networkSecurityGroupResult() != null) {
            networkSecurityGroupResult().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("profile", this.profile);
        jsonWriter.writeJsonField("networkSecurityGroupResult", this.networkSecurityGroupResult);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkConfigurationDiagnosticResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkConfigurationDiagnosticResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkConfigurationDiagnosticResult.
     */
    public static NetworkConfigurationDiagnosticResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkConfigurationDiagnosticResult deserializedNetworkConfigurationDiagnosticResult
                = new NetworkConfigurationDiagnosticResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("profile".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticResult.profile
                        = NetworkConfigurationDiagnosticProfile.fromJson(reader);
                } else if ("networkSecurityGroupResult".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticResult.networkSecurityGroupResult
                        = NetworkSecurityGroupResult.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkConfigurationDiagnosticResult;
        });
    }
}
