// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * SKU of nat gateway.
 */
@Fluent
public final class NatGatewaySku implements JsonSerializable<NatGatewaySku> {
    /*
     * Name of Nat Gateway SKU.
     */
    private NatGatewaySkuName name;

    /**
     * Creates an instance of NatGatewaySku class.
     */
    public NatGatewaySku() {
    }

    /**
     * Get the name property: Name of Nat Gateway SKU.
     * 
     * @return the name value.
     */
    public NatGatewaySkuName name() {
        return this.name;
    }

    /**
     * Set the name property: Name of Nat Gateway SKU.
     * 
     * @param name the name value to set.
     * @return the NatGatewaySku object itself.
     */
    public NatGatewaySku withName(NatGatewaySkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NatGatewaySku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NatGatewaySku if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NatGatewaySku.
     */
    public static NatGatewaySku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NatGatewaySku deserializedNatGatewaySku = new NatGatewaySku();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedNatGatewaySku.name = NatGatewaySkuName.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNatGatewaySku;
        });
    }
}
