// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The request for a migrateToIpBased API.
 */
@Fluent
public final class MigrateLoadBalancerToIpBasedRequest
    implements JsonSerializable<MigrateLoadBalancerToIpBasedRequest> {
    /*
     * A list of pool names that should be migrated from Nic based to IP based pool
     */
    private List<String> pools;

    /**
     * Creates an instance of MigrateLoadBalancerToIpBasedRequest class.
     */
    public MigrateLoadBalancerToIpBasedRequest() {
    }

    /**
     * Get the pools property: A list of pool names that should be migrated from Nic based to IP based pool.
     * 
     * @return the pools value.
     */
    public List<String> pools() {
        return this.pools;
    }

    /**
     * Set the pools property: A list of pool names that should be migrated from Nic based to IP based pool.
     * 
     * @param pools the pools value to set.
     * @return the MigrateLoadBalancerToIpBasedRequest object itself.
     */
    public MigrateLoadBalancerToIpBasedRequest withPools(List<String> pools) {
        this.pools = pools;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("pools", this.pools, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateLoadBalancerToIpBasedRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateLoadBalancerToIpBasedRequest if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrateLoadBalancerToIpBasedRequest.
     */
    public static MigrateLoadBalancerToIpBasedRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateLoadBalancerToIpBasedRequest deserializedMigrateLoadBalancerToIpBasedRequest
                = new MigrateLoadBalancerToIpBasedRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("pools".equals(fieldName)) {
                    List<String> pools = reader.readArray(reader1 -> reader1.getString());
                    deserializedMigrateLoadBalancerToIpBasedRequest.pools = pools;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateLoadBalancerToIpBasedRequest;
        });
    }
}
