// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Properties of IpamPool resource properties which are specific to the Pool resource.
 */
@Fluent
public final class IpamPoolProperties implements JsonSerializable<IpamPoolProperties> {
    /*
     * The description property.
     */
    private String description;

    /*
     * String representing a friendly name for the resource.
     */
    private String displayName;

    /*
     * List of IP address type for the IpamPool.
     */
    private List<IpType> ipAddressType;

    /*
     * String representing parent IpamPool resource name. If empty the IpamPool will be a root pool.
     */
    private String parentPoolName;

    /*
     * List of IP address prefixes of the resource.
     */
    private List<String> addressPrefixes;

    /*
     * Provisioning states of a resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of IpamPoolProperties class.
     */
    public IpamPoolProperties() {
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the IpamPoolProperties object itself.
     */
    public IpamPoolProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: String representing a friendly name for the resource.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: String representing a friendly name for the resource.
     * 
     * @param displayName the displayName value to set.
     * @return the IpamPoolProperties object itself.
     */
    public IpamPoolProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the ipAddressType property: List of IP address type for the IpamPool.
     * 
     * @return the ipAddressType value.
     */
    public List<IpType> ipAddressType() {
        return this.ipAddressType;
    }

    /**
     * Get the parentPoolName property: String representing parent IpamPool resource name. If empty the IpamPool will be
     * a root pool.
     * 
     * @return the parentPoolName value.
     */
    public String parentPoolName() {
        return this.parentPoolName;
    }

    /**
     * Set the parentPoolName property: String representing parent IpamPool resource name. If empty the IpamPool will be
     * a root pool.
     * 
     * @param parentPoolName the parentPoolName value to set.
     * @return the IpamPoolProperties object itself.
     */
    public IpamPoolProperties withParentPoolName(String parentPoolName) {
        this.parentPoolName = parentPoolName;
        return this;
    }

    /**
     * Get the addressPrefixes property: List of IP address prefixes of the resource.
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: List of IP address prefixes of the resource.
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the IpamPoolProperties object itself.
     */
    public IpamPoolProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning states of a resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning states of a resource.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the IpamPoolProperties object itself.
     */
    public IpamPoolProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (addressPrefixes() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property addressPrefixes in model IpamPoolProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IpamPoolProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("parentPoolName", this.parentPoolName);
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpamPoolProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpamPoolProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IpamPoolProperties.
     */
    public static IpamPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpamPoolProperties deserializedIpamPoolProperties = new IpamPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedIpamPoolProperties.addressPrefixes = addressPrefixes;
                } else if ("description".equals(fieldName)) {
                    deserializedIpamPoolProperties.description = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedIpamPoolProperties.displayName = reader.getString();
                } else if ("ipAddressType".equals(fieldName)) {
                    List<IpType> ipAddressType = reader.readArray(reader1 -> IpType.fromString(reader1.getString()));
                    deserializedIpamPoolProperties.ipAddressType = ipAddressType;
                } else if ("parentPoolName".equals(fieldName)) {
                    deserializedIpamPoolProperties.parentPoolName = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedIpamPoolProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpamPoolProperties;
        });
    }
}
