// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.IpamPoolPrefixAllocationPool;
import java.io.IOException;
import java.util.List;

/**
 * IpamPool prefix allocation reference.
 */
@Fluent
public final class IpamPoolPrefixAllocation implements JsonSerializable<IpamPoolPrefixAllocation> {
    /*
     * The pool property.
     */
    private IpamPoolPrefixAllocationPool innerPool;

    /*
     * Number of IP addresses to allocate.
     */
    private String numberOfIpAddresses;

    /*
     * List of assigned IP address prefixes in the IpamPool of the associated resource.
     */
    private List<String> allocatedAddressPrefixes;

    /**
     * Creates an instance of IpamPoolPrefixAllocation class.
     */
    public IpamPoolPrefixAllocation() {
    }

    /**
     * Get the innerPool property: The pool property.
     * 
     * @return the innerPool value.
     */
    private IpamPoolPrefixAllocationPool innerPool() {
        return this.innerPool;
    }

    /**
     * Get the numberOfIpAddresses property: Number of IP addresses to allocate.
     * 
     * @return the numberOfIpAddresses value.
     */
    public String numberOfIpAddresses() {
        return this.numberOfIpAddresses;
    }

    /**
     * Set the numberOfIpAddresses property: Number of IP addresses to allocate.
     * 
     * @param numberOfIpAddresses the numberOfIpAddresses value to set.
     * @return the IpamPoolPrefixAllocation object itself.
     */
    public IpamPoolPrefixAllocation withNumberOfIpAddresses(String numberOfIpAddresses) {
        this.numberOfIpAddresses = numberOfIpAddresses;
        return this;
    }

    /**
     * Get the allocatedAddressPrefixes property: List of assigned IP address prefixes in the IpamPool of the associated
     * resource.
     * 
     * @return the allocatedAddressPrefixes value.
     */
    public List<String> allocatedAddressPrefixes() {
        return this.allocatedAddressPrefixes;
    }

    /**
     * Get the id property: Resource id of the associated Azure IpamPool resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.innerPool() == null ? null : this.innerPool().id();
    }

    /**
     * Set the id property: Resource id of the associated Azure IpamPool resource.
     * 
     * @param id the id value to set.
     * @return the IpamPoolPrefixAllocation object itself.
     */
    public IpamPoolPrefixAllocation withId(String id) {
        if (this.innerPool() == null) {
            this.innerPool = new IpamPoolPrefixAllocationPool();
        }
        this.innerPool().withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerPool() != null) {
            innerPool().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("pool", this.innerPool);
        jsonWriter.writeStringField("numberOfIpAddresses", this.numberOfIpAddresses);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpamPoolPrefixAllocation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpamPoolPrefixAllocation if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpamPoolPrefixAllocation.
     */
    public static IpamPoolPrefixAllocation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpamPoolPrefixAllocation deserializedIpamPoolPrefixAllocation = new IpamPoolPrefixAllocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("pool".equals(fieldName)) {
                    deserializedIpamPoolPrefixAllocation.innerPool = IpamPoolPrefixAllocationPool.fromJson(reader);
                } else if ("numberOfIpAddresses".equals(fieldName)) {
                    deserializedIpamPoolPrefixAllocation.numberOfIpAddresses = reader.getString();
                } else if ("allocatedAddressPrefixes".equals(fieldName)) {
                    List<String> allocatedAddressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedIpamPoolPrefixAllocation.allocatedAddressPrefixes = allocatedAddressPrefixes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpamPoolPrefixAllocation;
        });
    }
}
