// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Define user session group by clause variables.
 */
@Fluent
public final class GroupByVariable implements JsonSerializable<GroupByVariable> {
    /*
     * User Session clause variable.
     */
    private ApplicationGatewayFirewallUserSessionVariable variableName;

    /**
     * Creates an instance of GroupByVariable class.
     */
    public GroupByVariable() {
    }

    /**
     * Get the variableName property: User Session clause variable.
     * 
     * @return the variableName value.
     */
    public ApplicationGatewayFirewallUserSessionVariable variableName() {
        return this.variableName;
    }

    /**
     * Set the variableName property: User Session clause variable.
     * 
     * @param variableName the variableName value to set.
     * @return the GroupByVariable object itself.
     */
    public GroupByVariable withVariableName(ApplicationGatewayFirewallUserSessionVariable variableName) {
        this.variableName = variableName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (variableName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property variableName in model GroupByVariable"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GroupByVariable.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("variableName", this.variableName == null ? null : this.variableName.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GroupByVariable from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GroupByVariable if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GroupByVariable.
     */
    public static GroupByVariable fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GroupByVariable deserializedGroupByVariable = new GroupByVariable();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("variableName".equals(fieldName)) {
                    deserializedGroupByVariable.variableName
                        = ApplicationGatewayFirewallUserSessionVariable.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGroupByVariable;
        });
    }
}
