// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The GatewayRouteSet model.
 */
@Fluent
public final class GatewayRouteSet implements JsonSerializable<GatewayRouteSet> {
    /*
     * Route Set name
     */
    private String name;

    /*
     * List of different locations from where the routes are learned
     */
    private List<String> locations;

    /*
     * List of different Route Sources
     */
    private Map<String, List<RouteSourceDetails>> details;

    /**
     * Creates an instance of GatewayRouteSet class.
     */
    public GatewayRouteSet() {
    }

    /**
     * Get the name property: Route Set name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Route Set name.
     * 
     * @param name the name value to set.
     * @return the GatewayRouteSet object itself.
     */
    public GatewayRouteSet withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the locations property: List of different locations from where the routes are learned.
     * 
     * @return the locations value.
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Set the locations property: List of different locations from where the routes are learned.
     * 
     * @param locations the locations value to set.
     * @return the GatewayRouteSet object itself.
     */
    public GatewayRouteSet withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Get the details property: List of different Route Sources.
     * 
     * @return the details value.
     */
    public Map<String, List<RouteSourceDetails>> details() {
        return this.details;
    }

    /**
     * Set the details property: List of different Route Sources.
     * 
     * @param details the details value to set.
     * @return the GatewayRouteSet object itself.
     */
    public GatewayRouteSet withDetails(Map<String, List<RouteSourceDetails>> details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (details() != null) {
            details().values().forEach(e -> {
                if (e != null) {
                    e.forEach(e1 -> e1.validate());
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("details", this.details,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson(element1)));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayRouteSet from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayRouteSet if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GatewayRouteSet.
     */
    public static GatewayRouteSet fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayRouteSet deserializedGatewayRouteSet = new GatewayRouteSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedGatewayRouteSet.name = reader.getString();
                } else if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedGatewayRouteSet.locations = locations;
                } else if ("details".equals(fieldName)) {
                    Map<String, List<RouteSourceDetails>> details
                        = reader.readMap(reader1 -> reader1.readArray(reader2 -> RouteSourceDetails.fromJson(reader2)));
                    deserializedGatewayRouteSet.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayRouteSet;
        });
    }
}
