// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * GatewayCustomBgpIpAddressIpConfiguration for a virtual network gateway connection.
 */
@Fluent
public final class GatewayCustomBgpIpAddressIpConfiguration
    implements JsonSerializable<GatewayCustomBgpIpAddressIpConfiguration> {
    /*
     * The IpconfigurationId of ipconfiguration which belongs to gateway.
     */
    private String ipConfigurationId;

    /*
     * The custom BgpPeeringAddress which belongs to IpconfigurationId.
     */
    private String customBgpIpAddress;

    /**
     * Creates an instance of GatewayCustomBgpIpAddressIpConfiguration class.
     */
    public GatewayCustomBgpIpAddressIpConfiguration() {
    }

    /**
     * Get the ipConfigurationId property: The IpconfigurationId of ipconfiguration which belongs to gateway.
     * 
     * @return the ipConfigurationId value.
     */
    public String ipConfigurationId() {
        return this.ipConfigurationId;
    }

    /**
     * Set the ipConfigurationId property: The IpconfigurationId of ipconfiguration which belongs to gateway.
     * 
     * @param ipConfigurationId the ipConfigurationId value to set.
     * @return the GatewayCustomBgpIpAddressIpConfiguration object itself.
     */
    public GatewayCustomBgpIpAddressIpConfiguration withIpConfigurationId(String ipConfigurationId) {
        this.ipConfigurationId = ipConfigurationId;
        return this;
    }

    /**
     * Get the customBgpIpAddress property: The custom BgpPeeringAddress which belongs to IpconfigurationId.
     * 
     * @return the customBgpIpAddress value.
     */
    public String customBgpIpAddress() {
        return this.customBgpIpAddress;
    }

    /**
     * Set the customBgpIpAddress property: The custom BgpPeeringAddress which belongs to IpconfigurationId.
     * 
     * @param customBgpIpAddress the customBgpIpAddress value to set.
     * @return the GatewayCustomBgpIpAddressIpConfiguration object itself.
     */
    public GatewayCustomBgpIpAddressIpConfiguration withCustomBgpIpAddress(String customBgpIpAddress) {
        this.customBgpIpAddress = customBgpIpAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipConfigurationId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ipConfigurationId in model GatewayCustomBgpIpAddressIpConfiguration"));
        }
        if (customBgpIpAddress() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property customBgpIpAddress in model GatewayCustomBgpIpAddressIpConfiguration"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GatewayCustomBgpIpAddressIpConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipConfigurationId", this.ipConfigurationId);
        jsonWriter.writeStringField("customBgpIpAddress", this.customBgpIpAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GatewayCustomBgpIpAddressIpConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GatewayCustomBgpIpAddressIpConfiguration if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GatewayCustomBgpIpAddressIpConfiguration.
     */
    public static GatewayCustomBgpIpAddressIpConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GatewayCustomBgpIpAddressIpConfiguration deserializedGatewayCustomBgpIpAddressIpConfiguration
                = new GatewayCustomBgpIpAddressIpConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipConfigurationId".equals(fieldName)) {
                    deserializedGatewayCustomBgpIpAddressIpConfiguration.ipConfigurationId = reader.getString();
                } else if ("customBgpIpAddress".equals(fieldName)) {
                    deserializedGatewayCustomBgpIpAddressIpConfiguration.customBgpIpAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGatewayCustomBgpIpAddressIpConfiguration;
        });
    }
}
