// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ExpressRoutePortsLocationInner;
import java.io.IOException;
import java.util.List;

/**
 * ExpressRoutePorts Location List Result
 * 
 * Response for ListExpressRoutePortsLocations API service call.
 */
@Fluent
public final class ExpressRoutePortsLocationListResult
    implements JsonSerializable<ExpressRoutePortsLocationListResult> {
    /*
     * The list of all ExpressRoutePort peering locations.
     */
    private List<ExpressRoutePortsLocationInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ExpressRoutePortsLocationListResult class.
     */
    public ExpressRoutePortsLocationListResult() {
    }

    /**
     * Get the value property: The list of all ExpressRoutePort peering locations.
     * 
     * @return the value value.
     */
    public List<ExpressRoutePortsLocationInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of all ExpressRoutePort peering locations.
     * 
     * @param value the value value to set.
     * @return the ExpressRoutePortsLocationListResult object itself.
     */
    public ExpressRoutePortsLocationListResult withValue(List<ExpressRoutePortsLocationInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ExpressRoutePortsLocationListResult object itself.
     */
    public ExpressRoutePortsLocationListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRoutePortsLocationListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRoutePortsLocationListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRoutePortsLocationListResult.
     */
    public static ExpressRoutePortsLocationListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRoutePortsLocationListResult deserializedExpressRoutePortsLocationListResult
                = new ExpressRoutePortsLocationListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ExpressRoutePortsLocationInner> value
                        = reader.readArray(reader1 -> ExpressRoutePortsLocationInner.fromJson(reader1));
                    deserializedExpressRoutePortsLocationListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedExpressRoutePortsLocationListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRoutePortsLocationListResult;
        });
    }
}
