// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration for auto scaling.
 */
@Fluent
public final class ExpressRouteGatewayPropertiesAutoScaleConfiguration
    implements JsonSerializable<ExpressRouteGatewayPropertiesAutoScaleConfiguration> {
    /*
     * Minimum and maximum number of scale units to deploy.
     */
    private ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds bounds;

    /**
     * Creates an instance of ExpressRouteGatewayPropertiesAutoScaleConfiguration class.
     */
    public ExpressRouteGatewayPropertiesAutoScaleConfiguration() {
    }

    /**
     * Get the bounds property: Minimum and maximum number of scale units to deploy.
     * 
     * @return the bounds value.
     */
    public ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds bounds() {
        return this.bounds;
    }

    /**
     * Set the bounds property: Minimum and maximum number of scale units to deploy.
     * 
     * @param bounds the bounds value to set.
     * @return the ExpressRouteGatewayPropertiesAutoScaleConfiguration object itself.
     */
    public ExpressRouteGatewayPropertiesAutoScaleConfiguration
        withBounds(ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds bounds) {
        this.bounds = bounds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (bounds() != null) {
            bounds().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("bounds", this.bounds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteGatewayPropertiesAutoScaleConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteGatewayPropertiesAutoScaleConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteGatewayPropertiesAutoScaleConfiguration.
     */
    public static ExpressRouteGatewayPropertiesAutoScaleConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteGatewayPropertiesAutoScaleConfiguration deserializedExpressRouteGatewayPropertiesAutoScaleConfiguration
                = new ExpressRouteGatewayPropertiesAutoScaleConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("bounds".equals(fieldName)) {
                    deserializedExpressRouteGatewayPropertiesAutoScaleConfiguration.bounds
                        = ExpressRouteGatewayPropertiesAutoScaleConfigurationBounds.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteGatewayPropertiesAutoScaleConfiguration;
        });
    }
}
