// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines a managed rule group to use for exclusion.
 */
@Fluent
public final class ExclusionManagedRuleGroup implements JsonSerializable<ExclusionManagedRuleGroup> {
    /*
     * The managed rule group for exclusion.
     */
    private String ruleGroupName;

    /*
     * List of rules that will be excluded. If none specified, all rules in the group will be excluded.
     */
    private List<ExclusionManagedRule> rules;

    /**
     * Creates an instance of ExclusionManagedRuleGroup class.
     */
    public ExclusionManagedRuleGroup() {
    }

    /**
     * Get the ruleGroupName property: The managed rule group for exclusion.
     * 
     * @return the ruleGroupName value.
     */
    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    /**
     * Set the ruleGroupName property: The managed rule group for exclusion.
     * 
     * @param ruleGroupName the ruleGroupName value to set.
     * @return the ExclusionManagedRuleGroup object itself.
     */
    public ExclusionManagedRuleGroup withRuleGroupName(String ruleGroupName) {
        this.ruleGroupName = ruleGroupName;
        return this;
    }

    /**
     * Get the rules property: List of rules that will be excluded. If none specified, all rules in the group will be
     * excluded.
     * 
     * @return the rules value.
     */
    public List<ExclusionManagedRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of rules that will be excluded. If none specified, all rules in the group will be
     * excluded.
     * 
     * @param rules the rules value to set.
     * @return the ExclusionManagedRuleGroup object itself.
     */
    public ExclusionManagedRuleGroup withRules(List<ExclusionManagedRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleGroupName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ruleGroupName in model ExclusionManagedRuleGroup"));
        }
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ExclusionManagedRuleGroup.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleGroupName", this.ruleGroupName);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExclusionManagedRuleGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExclusionManagedRuleGroup if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ExclusionManagedRuleGroup.
     */
    public static ExclusionManagedRuleGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExclusionManagedRuleGroup deserializedExclusionManagedRuleGroup = new ExclusionManagedRuleGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleGroupName".equals(fieldName)) {
                    deserializedExclusionManagedRuleGroup.ruleGroupName = reader.getString();
                } else if ("rules".equals(fieldName)) {
                    List<ExclusionManagedRule> rules
                        = reader.readArray(reader1 -> ExclusionManagedRule.fromJson(reader1));
                    deserializedExclusionManagedRuleGroup.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExclusionManagedRuleGroup;
        });
    }
}
