// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Effective Route.
 */
@Fluent
public final class EffectiveRoute implements JsonSerializable<EffectiveRoute> {
    /*
     * The name of the user defined route. This is optional.
     */
    private String name;

    /*
     * If true, on-premises routes are not propagated to the network interfaces in the subnet.
     */
    private Boolean disableBgpRoutePropagation;

    /*
     * Who created the route.
     */
    private EffectiveRouteSource source;

    /*
     * The value of effective route.
     */
    private EffectiveRouteState state;

    /*
     * The address prefixes of the effective routes in CIDR notation.
     */
    private List<String> addressPrefix;

    /*
     * The IP address of the next hop of the effective route.
     */
    private List<String> nextHopIpAddress;

    /*
     * The type of Azure hop the packet should be sent to.
     */
    private RouteNextHopType nextHopType;

    /**
     * Creates an instance of EffectiveRoute class.
     */
    public EffectiveRoute() {
    }

    /**
     * Get the name property: The name of the user defined route. This is optional.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the user defined route. This is optional.
     * 
     * @param name the name value to set.
     * @return the EffectiveRoute object itself.
     */
    public EffectiveRoute withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the disableBgpRoutePropagation property: If true, on-premises routes are not propagated to the network
     * interfaces in the subnet.
     * 
     * @return the disableBgpRoutePropagation value.
     */
    public Boolean disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    /**
     * Set the disableBgpRoutePropagation property: If true, on-premises routes are not propagated to the network
     * interfaces in the subnet.
     * 
     * @param disableBgpRoutePropagation the disableBgpRoutePropagation value to set.
     * @return the EffectiveRoute object itself.
     */
    public EffectiveRoute withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    /**
     * Get the source property: Who created the route.
     * 
     * @return the source value.
     */
    public EffectiveRouteSource source() {
        return this.source;
    }

    /**
     * Set the source property: Who created the route.
     * 
     * @param source the source value to set.
     * @return the EffectiveRoute object itself.
     */
    public EffectiveRoute withSource(EffectiveRouteSource source) {
        this.source = source;
        return this;
    }

    /**
     * Get the state property: The value of effective route.
     * 
     * @return the state value.
     */
    public EffectiveRouteState state() {
        return this.state;
    }

    /**
     * Set the state property: The value of effective route.
     * 
     * @param state the state value to set.
     * @return the EffectiveRoute object itself.
     */
    public EffectiveRoute withState(EffectiveRouteState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the addressPrefix property: The address prefixes of the effective routes in CIDR notation.
     * 
     * @return the addressPrefix value.
     */
    public List<String> addressPrefix() {
        return this.addressPrefix;
    }

    /**
     * Set the addressPrefix property: The address prefixes of the effective routes in CIDR notation.
     * 
     * @param addressPrefix the addressPrefix value to set.
     * @return the EffectiveRoute object itself.
     */
    public EffectiveRoute withAddressPrefix(List<String> addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    /**
     * Get the nextHopIpAddress property: The IP address of the next hop of the effective route.
     * 
     * @return the nextHopIpAddress value.
     */
    public List<String> nextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    /**
     * Set the nextHopIpAddress property: The IP address of the next hop of the effective route.
     * 
     * @param nextHopIpAddress the nextHopIpAddress value to set.
     * @return the EffectiveRoute object itself.
     */
    public EffectiveRoute withNextHopIpAddress(List<String> nextHopIpAddress) {
        this.nextHopIpAddress = nextHopIpAddress;
        return this;
    }

    /**
     * Get the nextHopType property: The type of Azure hop the packet should be sent to.
     * 
     * @return the nextHopType value.
     */
    public RouteNextHopType nextHopType() {
        return this.nextHopType;
    }

    /**
     * Set the nextHopType property: The type of Azure hop the packet should be sent to.
     * 
     * @param nextHopType the nextHopType value to set.
     * @return the EffectiveRoute object itself.
     */
    public EffectiveRoute withNextHopType(RouteNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("disableBgpRoutePropagation", this.disableBgpRoutePropagation);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("addressPrefix", this.addressPrefix,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("nextHopIpAddress", this.nextHopIpAddress,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("nextHopType", this.nextHopType == null ? null : this.nextHopType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveRoute from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveRoute if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveRoute.
     */
    public static EffectiveRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveRoute deserializedEffectiveRoute = new EffectiveRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedEffectiveRoute.name = reader.getString();
                } else if ("disableBgpRoutePropagation".equals(fieldName)) {
                    deserializedEffectiveRoute.disableBgpRoutePropagation = reader.getNullable(JsonReader::getBoolean);
                } else if ("source".equals(fieldName)) {
                    deserializedEffectiveRoute.source = EffectiveRouteSource.fromString(reader.getString());
                } else if ("state".equals(fieldName)) {
                    deserializedEffectiveRoute.state = EffectiveRouteState.fromString(reader.getString());
                } else if ("addressPrefix".equals(fieldName)) {
                    List<String> addressPrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveRoute.addressPrefix = addressPrefix;
                } else if ("nextHopIpAddress".equals(fieldName)) {
                    List<String> nextHopIpAddress = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveRoute.nextHopIpAddress = nextHopIpAddress;
                } else if ("nextHopType".equals(fieldName)) {
                    deserializedEffectiveRoute.nextHopType = RouteNextHopType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveRoute;
        });
    }
}
