// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the connection monitor endpoint filter item.
 */
@Fluent
public final class ConnectionMonitorEndpointFilterItem
    implements JsonSerializable<ConnectionMonitorEndpointFilterItem> {
    /*
     * The type of item included in the filter. Currently only 'AgentAddress' is supported.
     */
    private ConnectionMonitorEndpointFilterItemType type;

    /*
     * The address of the filter item.
     */
    private String address;

    /**
     * Creates an instance of ConnectionMonitorEndpointFilterItem class.
     */
    public ConnectionMonitorEndpointFilterItem() {
    }

    /**
     * Get the type property: The type of item included in the filter. Currently only 'AgentAddress' is supported.
     * 
     * @return the type value.
     */
    public ConnectionMonitorEndpointFilterItemType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of item included in the filter. Currently only 'AgentAddress' is supported.
     * 
     * @param type the type value to set.
     * @return the ConnectionMonitorEndpointFilterItem object itself.
     */
    public ConnectionMonitorEndpointFilterItem withType(ConnectionMonitorEndpointFilterItemType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the address property: The address of the filter item.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The address of the filter item.
     * 
     * @param address the address value to set.
     * @return the ConnectionMonitorEndpointFilterItem object itself.
     */
    public ConnectionMonitorEndpointFilterItem withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("address", this.address);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectionMonitorEndpointFilterItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectionMonitorEndpointFilterItem if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConnectionMonitorEndpointFilterItem.
     */
    public static ConnectionMonitorEndpointFilterItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectionMonitorEndpointFilterItem deserializedConnectionMonitorEndpointFilterItem
                = new ConnectionMonitorEndpointFilterItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedConnectionMonitorEndpointFilterItem.type
                        = ConnectionMonitorEndpointFilterItemType.fromString(reader.getString());
                } else if ("address".equals(fieldName)) {
                    deserializedConnectionMonitorEndpointFilterItem.address = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectionMonitorEndpointFilterItem;
        });
    }
}
