// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Behavior to handle overlapped IP address space among members of the connected group of the connectivity
 * configuration.
 */
public final class ConnectedGroupAddressOverlap extends ExpandableStringEnum<ConnectedGroupAddressOverlap> {
    /**
     * Static value Allowed for ConnectedGroupAddressOverlap.
     */
    public static final ConnectedGroupAddressOverlap ALLOWED = fromString("Allowed");

    /**
     * Static value Disallowed for ConnectedGroupAddressOverlap.
     */
    public static final ConnectedGroupAddressOverlap DISALLOWED = fromString("Disallowed");

    /**
     * Creates a new instance of ConnectedGroupAddressOverlap value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ConnectedGroupAddressOverlap() {
    }

    /**
     * Creates or finds a ConnectedGroupAddressOverlap from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ConnectedGroupAddressOverlap.
     */
    public static ConnectedGroupAddressOverlap fromString(String name) {
        return fromString(name, ConnectedGroupAddressOverlap.class);
    }

    /**
     * Gets known ConnectedGroupAddressOverlap values.
     * 
     * @return known ConnectedGroupAddressOverlap values.
     */
    public static Collection<ConnectedGroupAddressOverlap> values() {
        return values(ConnectedGroupAddressOverlap.class);
    }
}
