// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The packet capture operation to perform. If the Start operation is selected, please provide all the fields in the
 * firewallPacketCaptureParameters to successfully initiate the packet capture. If the Status or Stop operation is
 * selected, only the operation field is required; all other fields in the firewallPacketCaptureParameters can be
 * omitted to successfully retrieve the capture status or stop the capture.
 */
public final class AzureFirewallPacketCaptureOperationType
    extends ExpandableStringEnum<AzureFirewallPacketCaptureOperationType> {
    /**
     * Static value Start for AzureFirewallPacketCaptureOperationType.
     */
    public static final AzureFirewallPacketCaptureOperationType START = fromString("Start");

    /**
     * Static value Status for AzureFirewallPacketCaptureOperationType.
     */
    public static final AzureFirewallPacketCaptureOperationType STATUS = fromString("Status");

    /**
     * Static value Stop for AzureFirewallPacketCaptureOperationType.
     */
    public static final AzureFirewallPacketCaptureOperationType STOP = fromString("Stop");

    /**
     * Creates a new instance of AzureFirewallPacketCaptureOperationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AzureFirewallPacketCaptureOperationType() {
    }

    /**
     * Creates or finds a AzureFirewallPacketCaptureOperationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AzureFirewallPacketCaptureOperationType.
     */
    public static AzureFirewallPacketCaptureOperationType fromString(String name) {
        return fromString(name, AzureFirewallPacketCaptureOperationType.class);
    }

    /**
     * Gets known AzureFirewallPacketCaptureOperationType values.
     * 
     * @return known AzureFirewallPacketCaptureOperationType values.
     */
    public static Collection<AzureFirewallPacketCaptureOperationType> values() {
        return values(AzureFirewallPacketCaptureOperationType.class);
    }
}
