// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the application rule protocol.
 */
@Fluent
public final class AzureFirewallApplicationRuleProtocol
    implements JsonSerializable<AzureFirewallApplicationRuleProtocol> {
    /*
     * Protocol type.
     */
    private AzureFirewallApplicationRuleProtocolType protocolType;

    /*
     * Port number for the protocol, cannot be greater than 64000. This field is optional.
     */
    private Integer port;

    /**
     * Creates an instance of AzureFirewallApplicationRuleProtocol class.
     */
    public AzureFirewallApplicationRuleProtocol() {
    }

    /**
     * Get the protocolType property: Protocol type.
     * 
     * @return the protocolType value.
     */
    public AzureFirewallApplicationRuleProtocolType protocolType() {
        return this.protocolType;
    }

    /**
     * Set the protocolType property: Protocol type.
     * 
     * @param protocolType the protocolType value to set.
     * @return the AzureFirewallApplicationRuleProtocol object itself.
     */
    public AzureFirewallApplicationRuleProtocol
        withProtocolType(AzureFirewallApplicationRuleProtocolType protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    /**
     * Get the port property: Port number for the protocol, cannot be greater than 64000. This field is optional.
     * 
     * @return the port value.
     */
    public Integer port() {
        return this.port;
    }

    /**
     * Set the port property: Port number for the protocol, cannot be greater than 64000. This field is optional.
     * 
     * @param port the port value to set.
     * @return the AzureFirewallApplicationRuleProtocol object itself.
     */
    public AzureFirewallApplicationRuleProtocol withPort(Integer port) {
        this.port = port;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocolType", this.protocolType == null ? null : this.protocolType.toString());
        jsonWriter.writeNumberField("port", this.port);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFirewallApplicationRuleProtocol from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFirewallApplicationRuleProtocol if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureFirewallApplicationRuleProtocol.
     */
    public static AzureFirewallApplicationRuleProtocol fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFirewallApplicationRuleProtocol deserializedAzureFirewallApplicationRuleProtocol
                = new AzureFirewallApplicationRuleProtocol();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("protocolType".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleProtocol.protocolType
                        = AzureFirewallApplicationRuleProtocolType.fromString(reader.getString());
                } else if ("port".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleProtocol.port = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFirewallApplicationRuleProtocol;
        });
    }
}
