// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.AvailableServiceAliasInner;
import java.io.IOException;
import java.util.List;

/**
 * An array of available service aliases.
 */
@Fluent
public final class AvailableServiceAliasesResult implements JsonSerializable<AvailableServiceAliasesResult> {
    /*
     * An array of available service aliases.
     */
    private List<AvailableServiceAliasInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of AvailableServiceAliasesResult class.
     */
    public AvailableServiceAliasesResult() {
    }

    /**
     * Get the value property: An array of available service aliases.
     * 
     * @return the value value.
     */
    public List<AvailableServiceAliasInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of available service aliases.
     * 
     * @param value the value value to set.
     * @return the AvailableServiceAliasesResult object itself.
     */
    public AvailableServiceAliasesResult withValue(List<AvailableServiceAliasInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvailableServiceAliasesResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvailableServiceAliasesResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvailableServiceAliasesResult.
     */
    public static AvailableServiceAliasesResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvailableServiceAliasesResult deserializedAvailableServiceAliasesResult
                = new AvailableServiceAliasesResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AvailableServiceAliasInner> value
                        = reader.readArray(reader1 -> AvailableServiceAliasInner.fromJson(reader1));
                    deserializedAvailableServiceAliasesResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAvailableServiceAliasesResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAvailableServiceAliasesResult;
        });
    }
}
