// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Application Gateway Ssl policy.
 */
@Fluent
public final class ApplicationGatewaySslPolicy implements JsonSerializable<ApplicationGatewaySslPolicy> {
    /*
     * Ssl protocols to be disabled on application gateway.
     */
    private List<ApplicationGatewaySslProtocol> disabledSslProtocols;

    /*
     * Type of Ssl Policy.
     */
    private ApplicationGatewaySslPolicyType policyType;

    /*
     * Name of Ssl predefined policy.
     */
    private ApplicationGatewaySslPolicyName policyName;

    /*
     * Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    private List<ApplicationGatewaySslCipherSuite> cipherSuites;

    /*
     * Minimum version of Ssl protocol to be supported on application gateway.
     */
    private ApplicationGatewaySslProtocol minProtocolVersion;

    /**
     * Creates an instance of ApplicationGatewaySslPolicy class.
     */
    public ApplicationGatewaySslPolicy() {
    }

    /**
     * Get the disabledSslProtocols property: Ssl protocols to be disabled on application gateway.
     * 
     * @return the disabledSslProtocols value.
     */
    public List<ApplicationGatewaySslProtocol> disabledSslProtocols() {
        return this.disabledSslProtocols;
    }

    /**
     * Set the disabledSslProtocols property: Ssl protocols to be disabled on application gateway.
     * 
     * @param disabledSslProtocols the disabledSslProtocols value to set.
     * @return the ApplicationGatewaySslPolicy object itself.
     */
    public ApplicationGatewaySslPolicy
        withDisabledSslProtocols(List<ApplicationGatewaySslProtocol> disabledSslProtocols) {
        this.disabledSslProtocols = disabledSslProtocols;
        return this;
    }

    /**
     * Get the policyType property: Type of Ssl Policy.
     * 
     * @return the policyType value.
     */
    public ApplicationGatewaySslPolicyType policyType() {
        return this.policyType;
    }

    /**
     * Set the policyType property: Type of Ssl Policy.
     * 
     * @param policyType the policyType value to set.
     * @return the ApplicationGatewaySslPolicy object itself.
     */
    public ApplicationGatewaySslPolicy withPolicyType(ApplicationGatewaySslPolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    /**
     * Get the policyName property: Name of Ssl predefined policy.
     * 
     * @return the policyName value.
     */
    public ApplicationGatewaySslPolicyName policyName() {
        return this.policyName;
    }

    /**
     * Set the policyName property: Name of Ssl predefined policy.
     * 
     * @param policyName the policyName value to set.
     * @return the ApplicationGatewaySslPolicy object itself.
     */
    public ApplicationGatewaySslPolicy withPolicyName(ApplicationGatewaySslPolicyName policyName) {
        this.policyName = policyName;
        return this;
    }

    /**
     * Get the cipherSuites property: Ssl cipher suites to be enabled in the specified order to application gateway.
     * 
     * @return the cipherSuites value.
     */
    public List<ApplicationGatewaySslCipherSuite> cipherSuites() {
        return this.cipherSuites;
    }

    /**
     * Set the cipherSuites property: Ssl cipher suites to be enabled in the specified order to application gateway.
     * 
     * @param cipherSuites the cipherSuites value to set.
     * @return the ApplicationGatewaySslPolicy object itself.
     */
    public ApplicationGatewaySslPolicy withCipherSuites(List<ApplicationGatewaySslCipherSuite> cipherSuites) {
        this.cipherSuites = cipherSuites;
        return this;
    }

    /**
     * Get the minProtocolVersion property: Minimum version of Ssl protocol to be supported on application gateway.
     * 
     * @return the minProtocolVersion value.
     */
    public ApplicationGatewaySslProtocol minProtocolVersion() {
        return this.minProtocolVersion;
    }

    /**
     * Set the minProtocolVersion property: Minimum version of Ssl protocol to be supported on application gateway.
     * 
     * @param minProtocolVersion the minProtocolVersion value to set.
     * @return the ApplicationGatewaySslPolicy object itself.
     */
    public ApplicationGatewaySslPolicy withMinProtocolVersion(ApplicationGatewaySslProtocol minProtocolVersion) {
        this.minProtocolVersion = minProtocolVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("disabledSslProtocols", this.disabledSslProtocols,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("policyType", this.policyType == null ? null : this.policyType.toString());
        jsonWriter.writeStringField("policyName", this.policyName == null ? null : this.policyName.toString());
        jsonWriter.writeArrayField("cipherSuites", this.cipherSuites,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("minProtocolVersion",
            this.minProtocolVersion == null ? null : this.minProtocolVersion.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewaySslPolicy from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewaySslPolicy if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewaySslPolicy.
     */
    public static ApplicationGatewaySslPolicy fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewaySslPolicy deserializedApplicationGatewaySslPolicy = new ApplicationGatewaySslPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("disabledSslProtocols".equals(fieldName)) {
                    List<ApplicationGatewaySslProtocol> disabledSslProtocols
                        = reader.readArray(reader1 -> ApplicationGatewaySslProtocol.fromString(reader1.getString()));
                    deserializedApplicationGatewaySslPolicy.disabledSslProtocols = disabledSslProtocols;
                } else if ("policyType".equals(fieldName)) {
                    deserializedApplicationGatewaySslPolicy.policyType
                        = ApplicationGatewaySslPolicyType.fromString(reader.getString());
                } else if ("policyName".equals(fieldName)) {
                    deserializedApplicationGatewaySslPolicy.policyName
                        = ApplicationGatewaySslPolicyName.fromString(reader.getString());
                } else if ("cipherSuites".equals(fieldName)) {
                    List<ApplicationGatewaySslCipherSuite> cipherSuites
                        = reader.readArray(reader1 -> ApplicationGatewaySslCipherSuite.fromString(reader1.getString()));
                    deserializedApplicationGatewaySslPolicy.cipherSuites = cipherSuites;
                } else if ("minProtocolVersion".equals(fieldName)) {
                    deserializedApplicationGatewaySslPolicy.minProtocolVersion
                        = ApplicationGatewaySslProtocol.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewaySslPolicy;
        });
    }
}
