// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Allow to exclude some variable satisfy the condition for the WAF check.
 */
@Fluent
public final class ApplicationGatewayFirewallExclusion
    implements JsonSerializable<ApplicationGatewayFirewallExclusion> {
    /*
     * The variable to be excluded.
     */
    private String matchVariable;

    /*
     * When matchVariable is a collection, operate on the selector to specify which elements in the collection this
     * exclusion applies to.
     */
    private String selectorMatchOperator;

    /*
     * When matchVariable is a collection, operator used to specify which elements in the collection this exclusion
     * applies to.
     */
    private String selector;

    /**
     * Creates an instance of ApplicationGatewayFirewallExclusion class.
     */
    public ApplicationGatewayFirewallExclusion() {
    }

    /**
     * Get the matchVariable property: The variable to be excluded.
     * 
     * @return the matchVariable value.
     */
    public String matchVariable() {
        return this.matchVariable;
    }

    /**
     * Set the matchVariable property: The variable to be excluded.
     * 
     * @param matchVariable the matchVariable value to set.
     * @return the ApplicationGatewayFirewallExclusion object itself.
     */
    public ApplicationGatewayFirewallExclusion withMatchVariable(String matchVariable) {
        this.matchVariable = matchVariable;
        return this;
    }

    /**
     * Get the selectorMatchOperator property: When matchVariable is a collection, operate on the selector to specify
     * which elements in the collection this exclusion applies to.
     * 
     * @return the selectorMatchOperator value.
     */
    public String selectorMatchOperator() {
        return this.selectorMatchOperator;
    }

    /**
     * Set the selectorMatchOperator property: When matchVariable is a collection, operate on the selector to specify
     * which elements in the collection this exclusion applies to.
     * 
     * @param selectorMatchOperator the selectorMatchOperator value to set.
     * @return the ApplicationGatewayFirewallExclusion object itself.
     */
    public ApplicationGatewayFirewallExclusion withSelectorMatchOperator(String selectorMatchOperator) {
        this.selectorMatchOperator = selectorMatchOperator;
        return this;
    }

    /**
     * Get the selector property: When matchVariable is a collection, operator used to specify which elements in the
     * collection this exclusion applies to.
     * 
     * @return the selector value.
     */
    public String selector() {
        return this.selector;
    }

    /**
     * Set the selector property: When matchVariable is a collection, operator used to specify which elements in the
     * collection this exclusion applies to.
     * 
     * @param selector the selector value to set.
     * @return the ApplicationGatewayFirewallExclusion object itself.
     */
    public ApplicationGatewayFirewallExclusion withSelector(String selector) {
        this.selector = selector;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (matchVariable() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property matchVariable in model ApplicationGatewayFirewallExclusion"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApplicationGatewayFirewallExclusion.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("matchVariable", this.matchVariable);
        jsonWriter.writeStringField("selectorMatchOperator", this.selectorMatchOperator);
        jsonWriter.writeStringField("selector", this.selector);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayFirewallExclusion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayFirewallExclusion if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApplicationGatewayFirewallExclusion.
     */
    public static ApplicationGatewayFirewallExclusion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayFirewallExclusion deserializedApplicationGatewayFirewallExclusion
                = new ApplicationGatewayFirewallExclusion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("matchVariable".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallExclusion.matchVariable = reader.getString();
                } else if ("selectorMatchOperator".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallExclusion.selectorMatchOperator = reader.getString();
                } else if ("selector".equals(fieldName)) {
                    deserializedApplicationGatewayFirewallExclusion.selector = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayFirewallExclusion;
        });
    }
}
