// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.network.fluent.NetworkSecurityPerimeterAccessRulesClient;
import com.azure.resourcemanager.network.fluent.models.NspAccessRuleInner;
import com.azure.resourcemanager.network.models.NspAccessRuleListResult;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in NetworkSecurityPerimeterAccessRulesClient.
 */
public final class NetworkSecurityPerimeterAccessRulesClientImpl implements NetworkSecurityPerimeterAccessRulesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final NetworkSecurityPerimeterAccessRulesService service;

    /**
     * The service client containing this operation class.
     */
    private final NetworkManagementClientImpl client;

    /**
     * Initializes an instance of NetworkSecurityPerimeterAccessRulesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    NetworkSecurityPerimeterAccessRulesClientImpl(NetworkManagementClientImpl client) {
        this.service = RestProxy.create(NetworkSecurityPerimeterAccessRulesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for NetworkManagementClientNetworkSecurityPerimeterAccessRules to be used
     * by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "NetworkManagementClientNetworkSecurityPerimeterAccessRules")
    public interface NetworkSecurityPerimeterAccessRulesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NspAccessRuleInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkSecurityPerimeterName") String networkSecurityPerimeterName,
            @PathParam("profileName") String profileName, @PathParam("accessRuleName") String accessRuleName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NspAccessRuleInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkSecurityPerimeterName") String networkSecurityPerimeterName,
            @PathParam("profileName") String profileName, @PathParam("accessRuleName") String accessRuleName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") NspAccessRuleInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkSecurityPerimeterName") String networkSecurityPerimeterName,
            @PathParam("profileName") String profileName, @PathParam("accessRuleName") String accessRuleName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NspAccessRuleListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkSecurityPerimeterName") String networkSecurityPerimeterName,
            @PathParam("profileName") String profileName, @QueryParam("api-version") String apiVersion,
            @QueryParam("$top") Integer top, @QueryParam("$skipToken") String skipToken,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}/reconcile")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Object>> reconcile(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("networkSecurityPerimeterName") String networkSecurityPerimeterName,
            @PathParam("profileName") String profileName, @PathParam("accessRuleName") String accessRuleName,
            @QueryParam("api-version") String apiVersion, @BodyParam("application/json") Object parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NspAccessRuleListResult>> listNext(@PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<NspAccessRuleInner>> getWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<NspAccessRuleInner>> getWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, accept, context);
    }

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NspAccessRuleInner> getAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName) {
        return getWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<NspAccessRuleInner> getWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Context context) {
        return getWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName,
            context).block();
    }

    /**
     * Gets the specified NSP access rule by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP access rule by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NspAccessRuleInner get(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName) {
        return getWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName,
            Context.NONE).getValue();
    }

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<NspAccessRuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, parameters,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<NspAccessRuleInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, parameters, accept, context);
    }

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NspAccessRuleInner> createOrUpdateAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, NspAccessRuleInner parameters) {
        return createOrUpdateWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName,
            accessRuleName, parameters).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<NspAccessRuleInner> createOrUpdateWithResponse(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, NspAccessRuleInner parameters,
        Context context) {
        return createOrUpdateWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName,
            accessRuleName, parameters, context).block();
    }

    /**
     * Creates or updates a network access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters that hold the NspAccessRule resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP access rule resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NspAccessRuleInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, NspAccessRuleInner parameters) {
        return createOrUpdateWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName,
            parameters, Context.NONE).getValue();
    }

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, accept, context);
    }

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName) {
        return deleteWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Context context) {
        return deleteWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName,
            context).block();
    }

    /**
     * Deletes an NSP access rule.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName) {
        deleteWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, Context.NONE);
    }

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listSinglePageAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                    networkSecurityPerimeterName, profileName, apiVersion, top, skipToken, accept, context))
            .<PagedResponse<NspAccessRuleInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listSinglePageAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                networkSecurityPerimeterName, profileName, apiVersion, top, skipToken, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, Integer top, String skipToken) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName) {
        final Integer top = null;
        final String skipToken = null;
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<NspAccessRuleInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, Integer top, String skipToken, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, networkSecurityPerimeterName, profileName,
            top, skipToken, context), nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NspAccessRuleInner> list(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName) {
        final Integer top = null;
        final String skipToken = null;
        return new PagedIterable<>(
            listAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken));
    }

    /**
     * Lists the NSP access rules in the specified NSP profile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NspAccessRuleInner> list(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, Integer top, String skipToken, Context context) {
        return new PagedIterable<>(
            listAsync(resourceGroupName, networkSecurityPerimeterName, profileName, top, skipToken, context));
    }

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Object>> reconcileWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, Object parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.reconcile(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, parameters,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Object>> reconcileWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String profileName, String accessRuleName, Object parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (networkSecurityPerimeterName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter networkSecurityPerimeterName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (accessRuleName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accessRuleName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        final String apiVersion = "2024-10-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.reconcile(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            networkSecurityPerimeterName, profileName, accessRuleName, apiVersion, parameters, accept, context);
    }

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Object> reconcileAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Object parameters) {
        return reconcileWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName,
            parameters).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Object> reconcileWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String profileName, String accessRuleName, Object parameters, Context context) {
        return reconcileWithResponseAsync(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName,
            parameters, context).block();
    }

    /**
     * Reconcile NSP access rules.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param profileName The name of the NSP profile.
     * @param accessRuleName The name of the NSP access rule.
     * @param parameters Parameters for NSP access rule reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Object reconcile(String resourceGroupName, String networkSecurityPerimeterName, String profileName,
        String accessRuleName, Object parameters) {
        return reconcileWithResponse(resourceGroupName, networkSecurityPerimeterName, profileName, accessRuleName,
            parameters, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<NspAccessRuleInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP access rules along with {@link PagedResponse} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NspAccessRuleInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
