// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AadAuthenticationParameters;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.RadiusServer;
import com.azure.resourcemanager.network.models.VpnAuthenticationType;
import com.azure.resourcemanager.network.models.VpnGatewayTunnelingProtocol;
import com.azure.resourcemanager.network.models.VpnServerConfigRadiusClientRootCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigRadiusServerRootCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigVpnClientRevokedCertificate;
import com.azure.resourcemanager.network.models.VpnServerConfigVpnClientRootCertificate;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for VpnServerConfiguration.
 */
@Fluent
public final class VpnServerConfigurationProperties implements JsonSerializable<VpnServerConfigurationProperties> {
    /*
     * The name of the VpnServerConfiguration that is unique within a resource group.
     */
    private String name;

    /*
     * VPN protocols for the VpnServerConfiguration.
     */
    private List<VpnGatewayTunnelingProtocol> vpnProtocols;

    /*
     * VPN authentication types for the VpnServerConfiguration.
     */
    private List<VpnAuthenticationType> vpnAuthenticationTypes;

    /*
     * VPN client root certificate of VpnServerConfiguration.
     */
    private List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates;

    /*
     * VPN client revoked certificate of VpnServerConfiguration.
     */
    private List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates;

    /*
     * Radius Server root certificate of VpnServerConfiguration.
     */
    private List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates;

    /*
     * Radius client root certificate of VpnServerConfiguration.
     */
    private List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates;

    /*
     * VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    private List<IpsecPolicy> vpnClientIpsecPolicies;

    /*
     * The radius server address property of the VpnServerConfiguration resource for point to site client connection.
     */
    private String radiusServerAddress;

    /*
     * The radius secret property of the VpnServerConfiguration resource for point to site client connection. We will no
     * longer return radiusServerSecret in VpnServerConfiguration Create/Update/Get/List/UpdateTags APIs response.
     * Please use VpnServerConfiguration ListRadiusSecrets API to fetch radius server secrets.
     */
    private String radiusServerSecret;

    /*
     * Multiple Radius Server configuration for VpnServerConfiguration.
     */
    private List<RadiusServer> radiusServers;

    /*
     * The set of aad vpn authentication parameters.
     */
    private AadAuthenticationParameters aadAuthenticationParameters;

    /*
     * The provisioning state of the VpnServerConfiguration resource. Possible values are: 'Updating', 'Deleting', and
     * 'Failed'.
     */
    private String provisioningState;

    /*
     * List of references to P2SVpnGateways.
     */
    private List<P2SVpnGatewayInner> p2SVpnGateways;

    /*
     * List of all VpnServerConfigurationPolicyGroups.
     */
    private List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /**
     * Creates an instance of VpnServerConfigurationProperties class.
     */
    public VpnServerConfigurationProperties() {
    }

    /**
     * Get the name property: The name of the VpnServerConfiguration that is unique within a resource group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the VpnServerConfiguration that is unique within a resource group.
     * 
     * @param name the name value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the vpnProtocols property: VPN protocols for the VpnServerConfiguration.
     * 
     * @return the vpnProtocols value.
     */
    public List<VpnGatewayTunnelingProtocol> vpnProtocols() {
        return this.vpnProtocols;
    }

    /**
     * Set the vpnProtocols property: VPN protocols for the VpnServerConfiguration.
     * 
     * @param vpnProtocols the vpnProtocols value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withVpnProtocols(List<VpnGatewayTunnelingProtocol> vpnProtocols) {
        this.vpnProtocols = vpnProtocols;
        return this;
    }

    /**
     * Get the vpnAuthenticationTypes property: VPN authentication types for the VpnServerConfiguration.
     * 
     * @return the vpnAuthenticationTypes value.
     */
    public List<VpnAuthenticationType> vpnAuthenticationTypes() {
        return this.vpnAuthenticationTypes;
    }

    /**
     * Set the vpnAuthenticationTypes property: VPN authentication types for the VpnServerConfiguration.
     * 
     * @param vpnAuthenticationTypes the vpnAuthenticationTypes value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties
        withVpnAuthenticationTypes(List<VpnAuthenticationType> vpnAuthenticationTypes) {
        this.vpnAuthenticationTypes = vpnAuthenticationTypes;
        return this;
    }

    /**
     * Get the vpnClientRootCertificates property: VPN client root certificate of VpnServerConfiguration.
     * 
     * @return the vpnClientRootCertificates value.
     */
    public List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates() {
        return this.vpnClientRootCertificates;
    }

    /**
     * Set the vpnClientRootCertificates property: VPN client root certificate of VpnServerConfiguration.
     * 
     * @param vpnClientRootCertificates the vpnClientRootCertificates value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties
        withVpnClientRootCertificates(List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates) {
        this.vpnClientRootCertificates = vpnClientRootCertificates;
        return this;
    }

    /**
     * Get the vpnClientRevokedCertificates property: VPN client revoked certificate of VpnServerConfiguration.
     * 
     * @return the vpnClientRevokedCertificates value.
     */
    public List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates() {
        return this.vpnClientRevokedCertificates;
    }

    /**
     * Set the vpnClientRevokedCertificates property: VPN client revoked certificate of VpnServerConfiguration.
     * 
     * @param vpnClientRevokedCertificates the vpnClientRevokedCertificates value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withVpnClientRevokedCertificates(
        List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates) {
        this.vpnClientRevokedCertificates = vpnClientRevokedCertificates;
        return this;
    }

    /**
     * Get the radiusServerRootCertificates property: Radius Server root certificate of VpnServerConfiguration.
     * 
     * @return the radiusServerRootCertificates value.
     */
    public List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates() {
        return this.radiusServerRootCertificates;
    }

    /**
     * Set the radiusServerRootCertificates property: Radius Server root certificate of VpnServerConfiguration.
     * 
     * @param radiusServerRootCertificates the radiusServerRootCertificates value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withRadiusServerRootCertificates(
        List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates) {
        this.radiusServerRootCertificates = radiusServerRootCertificates;
        return this;
    }

    /**
     * Get the radiusClientRootCertificates property: Radius client root certificate of VpnServerConfiguration.
     * 
     * @return the radiusClientRootCertificates value.
     */
    public List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates() {
        return this.radiusClientRootCertificates;
    }

    /**
     * Set the radiusClientRootCertificates property: Radius client root certificate of VpnServerConfiguration.
     * 
     * @param radiusClientRootCertificates the radiusClientRootCertificates value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withRadiusClientRootCertificates(
        List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates) {
        this.radiusClientRootCertificates = radiusClientRootCertificates;
        return this;
    }

    /**
     * Get the vpnClientIpsecPolicies property: VpnClientIpsecPolicies for VpnServerConfiguration.
     * 
     * @return the vpnClientIpsecPolicies value.
     */
    public List<IpsecPolicy> vpnClientIpsecPolicies() {
        return this.vpnClientIpsecPolicies;
    }

    /**
     * Set the vpnClientIpsecPolicies property: VpnClientIpsecPolicies for VpnServerConfiguration.
     * 
     * @param vpnClientIpsecPolicies the vpnClientIpsecPolicies value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withVpnClientIpsecPolicies(List<IpsecPolicy> vpnClientIpsecPolicies) {
        this.vpnClientIpsecPolicies = vpnClientIpsecPolicies;
        return this;
    }

    /**
     * Get the radiusServerAddress property: The radius server address property of the VpnServerConfiguration resource
     * for point to site client connection.
     * 
     * @return the radiusServerAddress value.
     */
    public String radiusServerAddress() {
        return this.radiusServerAddress;
    }

    /**
     * Set the radiusServerAddress property: The radius server address property of the VpnServerConfiguration resource
     * for point to site client connection.
     * 
     * @param radiusServerAddress the radiusServerAddress value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withRadiusServerAddress(String radiusServerAddress) {
        this.radiusServerAddress = radiusServerAddress;
        return this;
    }

    /**
     * Get the radiusServerSecret property: The radius secret property of the VpnServerConfiguration resource for point
     * to site client connection. We will no longer return radiusServerSecret in VpnServerConfiguration
     * Create/Update/Get/List/UpdateTags APIs response. Please use VpnServerConfiguration ListRadiusSecrets API to fetch
     * radius server secrets.
     * 
     * @return the radiusServerSecret value.
     */
    public String radiusServerSecret() {
        return this.radiusServerSecret;
    }

    /**
     * Set the radiusServerSecret property: The radius secret property of the VpnServerConfiguration resource for point
     * to site client connection. We will no longer return radiusServerSecret in VpnServerConfiguration
     * Create/Update/Get/List/UpdateTags APIs response. Please use VpnServerConfiguration ListRadiusSecrets API to fetch
     * radius server secrets.
     * 
     * @param radiusServerSecret the radiusServerSecret value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withRadiusServerSecret(String radiusServerSecret) {
        this.radiusServerSecret = radiusServerSecret;
        return this;
    }

    /**
     * Get the radiusServers property: Multiple Radius Server configuration for VpnServerConfiguration.
     * 
     * @return the radiusServers value.
     */
    public List<RadiusServer> radiusServers() {
        return this.radiusServers;
    }

    /**
     * Set the radiusServers property: Multiple Radius Server configuration for VpnServerConfiguration.
     * 
     * @param radiusServers the radiusServers value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties withRadiusServers(List<RadiusServer> radiusServers) {
        this.radiusServers = radiusServers;
        return this;
    }

    /**
     * Get the aadAuthenticationParameters property: The set of aad vpn authentication parameters.
     * 
     * @return the aadAuthenticationParameters value.
     */
    public AadAuthenticationParameters aadAuthenticationParameters() {
        return this.aadAuthenticationParameters;
    }

    /**
     * Set the aadAuthenticationParameters property: The set of aad vpn authentication parameters.
     * 
     * @param aadAuthenticationParameters the aadAuthenticationParameters value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties
        withAadAuthenticationParameters(AadAuthenticationParameters aadAuthenticationParameters) {
        this.aadAuthenticationParameters = aadAuthenticationParameters;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the VpnServerConfiguration resource. Possible
     * values are: 'Updating', 'Deleting', and 'Failed'.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the p2SVpnGateways property: List of references to P2SVpnGateways.
     * 
     * @return the p2SVpnGateways value.
     */
    public List<P2SVpnGatewayInner> p2SVpnGateways() {
        return this.p2SVpnGateways;
    }

    /**
     * Get the configurationPolicyGroups property: List of all VpnServerConfigurationPolicyGroups.
     * 
     * @return the configurationPolicyGroups value.
     */
    public List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups() {
        return this.configurationPolicyGroups;
    }

    /**
     * Set the configurationPolicyGroups property: List of all VpnServerConfigurationPolicyGroups.
     * 
     * @param configurationPolicyGroups the configurationPolicyGroups value to set.
     * @return the VpnServerConfigurationProperties object itself.
     */
    public VpnServerConfigurationProperties
        withConfigurationPolicyGroups(List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups) {
        this.configurationPolicyGroups = configurationPolicyGroups;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (vpnClientRootCertificates() != null) {
            vpnClientRootCertificates().forEach(e -> e.validate());
        }
        if (vpnClientRevokedCertificates() != null) {
            vpnClientRevokedCertificates().forEach(e -> e.validate());
        }
        if (radiusServerRootCertificates() != null) {
            radiusServerRootCertificates().forEach(e -> e.validate());
        }
        if (radiusClientRootCertificates() != null) {
            radiusClientRootCertificates().forEach(e -> e.validate());
        }
        if (vpnClientIpsecPolicies() != null) {
            vpnClientIpsecPolicies().forEach(e -> e.validate());
        }
        if (radiusServers() != null) {
            radiusServers().forEach(e -> e.validate());
        }
        if (aadAuthenticationParameters() != null) {
            aadAuthenticationParameters().validate();
        }
        if (p2SVpnGateways() != null) {
            p2SVpnGateways().forEach(e -> e.validate());
        }
        if (configurationPolicyGroups() != null) {
            configurationPolicyGroups().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("vpnProtocols", this.vpnProtocols,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnAuthenticationTypes", this.vpnAuthenticationTypes,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("vpnClientRootCertificates", this.vpnClientRootCertificates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("vpnClientRevokedCertificates", this.vpnClientRevokedCertificates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("radiusServerRootCertificates", this.radiusServerRootCertificates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("radiusClientRootCertificates", this.radiusClientRootCertificates,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("vpnClientIpsecPolicies", this.vpnClientIpsecPolicies,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("radiusServerAddress", this.radiusServerAddress);
        jsonWriter.writeStringField("radiusServerSecret", this.radiusServerSecret);
        jsonWriter.writeArrayField("radiusServers", this.radiusServers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("aadAuthenticationParameters", this.aadAuthenticationParameters);
        jsonWriter.writeArrayField("configurationPolicyGroups", this.configurationPolicyGroups,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnServerConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnServerConfigurationProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnServerConfigurationProperties.
     */
    public static VpnServerConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnServerConfigurationProperties deserializedVpnServerConfigurationProperties
                = new VpnServerConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.name = reader.getString();
                } else if ("vpnProtocols".equals(fieldName)) {
                    List<VpnGatewayTunnelingProtocol> vpnProtocols
                        = reader.readArray(reader1 -> VpnGatewayTunnelingProtocol.fromString(reader1.getString()));
                    deserializedVpnServerConfigurationProperties.vpnProtocols = vpnProtocols;
                } else if ("vpnAuthenticationTypes".equals(fieldName)) {
                    List<VpnAuthenticationType> vpnAuthenticationTypes
                        = reader.readArray(reader1 -> VpnAuthenticationType.fromString(reader1.getString()));
                    deserializedVpnServerConfigurationProperties.vpnAuthenticationTypes = vpnAuthenticationTypes;
                } else if ("vpnClientRootCertificates".equals(fieldName)) {
                    List<VpnServerConfigVpnClientRootCertificate> vpnClientRootCertificates
                        = reader.readArray(reader1 -> VpnServerConfigVpnClientRootCertificate.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.vpnClientRootCertificates = vpnClientRootCertificates;
                } else if ("vpnClientRevokedCertificates".equals(fieldName)) {
                    List<VpnServerConfigVpnClientRevokedCertificate> vpnClientRevokedCertificates
                        = reader.readArray(reader1 -> VpnServerConfigVpnClientRevokedCertificate.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.vpnClientRevokedCertificates
                        = vpnClientRevokedCertificates;
                } else if ("radiusServerRootCertificates".equals(fieldName)) {
                    List<VpnServerConfigRadiusServerRootCertificate> radiusServerRootCertificates
                        = reader.readArray(reader1 -> VpnServerConfigRadiusServerRootCertificate.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.radiusServerRootCertificates
                        = radiusServerRootCertificates;
                } else if ("radiusClientRootCertificates".equals(fieldName)) {
                    List<VpnServerConfigRadiusClientRootCertificate> radiusClientRootCertificates
                        = reader.readArray(reader1 -> VpnServerConfigRadiusClientRootCertificate.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.radiusClientRootCertificates
                        = radiusClientRootCertificates;
                } else if ("vpnClientIpsecPolicies".equals(fieldName)) {
                    List<IpsecPolicy> vpnClientIpsecPolicies
                        = reader.readArray(reader1 -> IpsecPolicy.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.vpnClientIpsecPolicies = vpnClientIpsecPolicies;
                } else if ("radiusServerAddress".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.radiusServerAddress = reader.getString();
                } else if ("radiusServerSecret".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.radiusServerSecret = reader.getString();
                } else if ("radiusServers".equals(fieldName)) {
                    List<RadiusServer> radiusServers = reader.readArray(reader1 -> RadiusServer.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.radiusServers = radiusServers;
                } else if ("aadAuthenticationParameters".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.aadAuthenticationParameters
                        = AadAuthenticationParameters.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.provisioningState = reader.getString();
                } else if ("p2SVpnGateways".equals(fieldName)) {
                    List<P2SVpnGatewayInner> p2SVpnGateways
                        = reader.readArray(reader1 -> P2SVpnGatewayInner.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.p2SVpnGateways = p2SVpnGateways;
                } else if ("configurationPolicyGroups".equals(fieldName)) {
                    List<VpnServerConfigurationPolicyGroupInner> configurationPolicyGroups
                        = reader.readArray(reader1 -> VpnServerConfigurationPolicyGroupInner.fromJson(reader1));
                    deserializedVpnServerConfigurationProperties.configurationPolicyGroups = configurationPolicyGroups;
                } else if ("etag".equals(fieldName)) {
                    deserializedVpnServerConfigurationProperties.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnServerConfigurationProperties;
        });
    }
}
