// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.VirtualNetworkUsageName;
import java.io.IOException;

/**
 * Usage details for subnet.
 */
@Immutable
public final class VirtualNetworkUsageInner implements JsonSerializable<VirtualNetworkUsageInner> {
    /*
     * Indicates number of IPs used from the Subnet.
     */
    private Double currentValue;

    /*
     * Subnet identifier.
     */
    private String id;

    /*
     * Indicates the size of the subnet.
     */
    private Double limit;

    /*
     * The name containing common and localized value for usage.
     */
    private VirtualNetworkUsageName name;

    /*
     * Usage units. Returns 'Count'.
     */
    private String unit;

    /**
     * Creates an instance of VirtualNetworkUsageInner class.
     */
    public VirtualNetworkUsageInner() {
    }

    /**
     * Get the currentValue property: Indicates number of IPs used from the Subnet.
     * 
     * @return the currentValue value.
     */
    public Double currentValue() {
        return this.currentValue;
    }

    /**
     * Get the id property: Subnet identifier.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the limit property: Indicates the size of the subnet.
     * 
     * @return the limit value.
     */
    public Double limit() {
        return this.limit;
    }

    /**
     * Get the name property: The name containing common and localized value for usage.
     * 
     * @return the name value.
     */
    public VirtualNetworkUsageName name() {
        return this.name;
    }

    /**
     * Get the unit property: Usage units. Returns 'Count'.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkUsageInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkUsageInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkUsageInner.
     */
    public static VirtualNetworkUsageInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkUsageInner deserializedVirtualNetworkUsageInner = new VirtualNetworkUsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("currentValue".equals(fieldName)) {
                    deserializedVirtualNetworkUsageInner.currentValue = reader.getNullable(JsonReader::getDouble);
                } else if ("id".equals(fieldName)) {
                    deserializedVirtualNetworkUsageInner.id = reader.getString();
                } else if ("limit".equals(fieldName)) {
                    deserializedVirtualNetworkUsageInner.limit = reader.getNullable(JsonReader::getDouble);
                } else if ("name".equals(fieldName)) {
                    deserializedVirtualNetworkUsageInner.name = VirtualNetworkUsageName.fromJson(reader);
                } else if ("unit".equals(fieldName)) {
                    deserializedVirtualNetworkUsageInner.unit = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkUsageInner;
        });
    }
}
