// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Storage location provided for troubleshoot.
 */
@Fluent
public final class TroubleshootingProperties implements JsonSerializable<TroubleshootingProperties> {
    /*
     * The ID for the storage account to save the troubleshoot result.
     */
    private String storageId;

    /*
     * The path to the blob to save the troubleshoot result in.
     */
    private String storagePath;

    /**
     * Creates an instance of TroubleshootingProperties class.
     */
    public TroubleshootingProperties() {
    }

    /**
     * Get the storageId property: The ID for the storage account to save the troubleshoot result.
     * 
     * @return the storageId value.
     */
    public String storageId() {
        return this.storageId;
    }

    /**
     * Set the storageId property: The ID for the storage account to save the troubleshoot result.
     * 
     * @param storageId the storageId value to set.
     * @return the TroubleshootingProperties object itself.
     */
    public TroubleshootingProperties withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    /**
     * Get the storagePath property: The path to the blob to save the troubleshoot result in.
     * 
     * @return the storagePath value.
     */
    public String storagePath() {
        return this.storagePath;
    }

    /**
     * Set the storagePath property: The path to the blob to save the troubleshoot result in.
     * 
     * @param storagePath the storagePath value to set.
     * @return the TroubleshootingProperties object itself.
     */
    public TroubleshootingProperties withStoragePath(String storagePath) {
        this.storagePath = storagePath;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageId in model TroubleshootingProperties"));
        }
        if (storagePath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storagePath in model TroubleshootingProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TroubleshootingProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageId", this.storageId);
        jsonWriter.writeStringField("storagePath", this.storagePath);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TroubleshootingProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TroubleshootingProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TroubleshootingProperties.
     */
    public static TroubleshootingProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TroubleshootingProperties deserializedTroubleshootingProperties = new TroubleshootingProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageId".equals(fieldName)) {
                    deserializedTroubleshootingProperties.storageId = reader.getString();
                } else if ("storagePath".equals(fieldName)) {
                    deserializedTroubleshootingProperties.storagePath = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTroubleshootingProperties;
        });
    }
}
